/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.random;

import net.doodleproject.numerics4j.random.AbstractContinuousRandomVariable;
import net.doodleproject.numerics4j.random.RNG;
import net.doodleproject.numerics4j.random.RandomRNG;

public class ExponentialRandomVariable
extends AbstractContinuousRandomVariable {
    private double mean;

    public ExponentialRandomVariable() {
        this(1.0);
    }

    public ExponentialRandomVariable(double m) {
        this(m, new RandomRNG());
    }

    public ExponentialRandomVariable(double m, RNG source) {
        super(source);
        this.setMean(m);
    }

    public static double nextRandomVariable(double m, RNG source) {
        double u;
        while ((u = source.nextRandomNumber()) <= 0.0) {
        }
        return -m * Math.log(u);
    }

    private double getMean() {
        return this.mean;
    }

    @Override
    public double nextRandomVariable() {
        return ExponentialRandomVariable.nextRandomVariable(this.getMean(), this.getSource());
    }

    private void setMean(double m) {
        if (m <= 0.0 || Double.isNaN(m)) {
            throw new IllegalArgumentException("Mean must be positive.");
        }
        this.mean = m;
    }
}

