/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.Constant;
import jasymca.Exakt;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.Polynomial;
import jasymca.Root;
import jasymca.Unexakt;
import jasymca.Variable;
import jasymca.Vektor;

public abstract class Zahl
extends Algebraic {
    public static Zahl ZERO = new Unexakt(0.0);
    public static Zahl HALF = new Unexakt(0.5);
    public static Zahl ONE = new Unexakt(1.0);
    public static Zahl TWO = new Unexakt(2.0);
    public static Zahl THREE = new Unexakt(3.0);
    public static Zahl MINUS = new Unexakt(-1.0);
    public static Zahl IONE = new Unexakt(0.0, 1.0);
    public static Zahl IMINUS = new Unexakt(0.0, -1.0);
    public static Polynomial PI = new Polynomial(new Constant("pi", Math.PI));
    public static Algebraic SQRT2 = new Polynomial(new Root(new Vektor(new Algebraic[]{new Unexakt(-2.0), ZERO, ONE}), 0));
    public static Algebraic SQRT3 = new Polynomial(new Root(new Vektor(new Algebraic[]{new Unexakt(-3.0), ZERO, ONE}), 0));

    @Override
    public boolean constantq() {
        return true;
    }

    @Override
    public Algebraic deriv(Variable var) {
        return ZERO;
    }

    @Override
    public Algebraic integrate(Variable var) throws JasymcaException {
        if (this.equals(ZERO)) {
            return this;
        }
        return new Polynomial(var).mult(this);
    }

    public abstract int intval();

    public abstract boolean imagq();

    @Override
    public Algebraic value(Variable var, Algebraic x) throws JasymcaException {
        return this;
    }

    @Override
    public Algebraic cc() throws JasymcaException {
        return this.realpart().add(this.imagpart().mult(IMINUS));
    }

    public abstract Zahl abs();

    public Exakt exakt() {
        return this instanceof Exakt ? (Exakt)this : new Exakt(((Unexakt)this).real, ((Unexakt)this).imag);
    }

    public Unexakt unexakt() {
        return this instanceof Unexakt ? (Unexakt)this : ((Exakt)this).tofloat();
    }

    @Override
    public Algebraic map(LambdaAlgebraic f) throws JasymcaException {
        return f.f(this);
    }

    public Zahl gcd(Zahl x) throws JasymcaException {
        return this.exakt().gcd(x.exakt());
    }

    public abstract boolean smaller(Zahl var1) throws JasymcaException;

    public Algebraic[] div(Algebraic q1, Algebraic[] result) throws JasymcaException {
        return this.exakt().div(q1, result);
    }

    public abstract boolean integerq();
}

