/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.Matrix;
import jasymca.ParseException;
import jasymca.Vektor;
import java.util.Stack;

class MMU
extends LambdaAlgebraic {
    MMU() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = MMU.getNarg(st);
        if (narg != 2) {
            throw new ParseException("Wrong number of arguments for \"*\".");
        }
        Algebraic b = MMU.getAlgebraic(st);
        Algebraic a = MMU.getAlgebraic(st);
        if (b.scalarq()) {
            st.push(a.mult(b));
        } else if (a.scalarq()) {
            st.push(b.mult(a));
        } else if (a instanceof Vektor && b instanceof Vektor) {
            st.push(a.mult(b));
        } else {
            st.push(new Matrix(a).mult(new Matrix(b)).reduce());
        }
        return 0;
    }
}

