/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.Unexakt;
import jasymca.Zahl;

class LambdaTAN
extends LambdaAlgebraic {
    public LambdaTAN() {
        this.diffrule = "1/(cos(x))^2";
        this.intrule = "-log(cos(x))";
        this.trigrule = "-i*(exp(i*x)-exp(-i*x))/(exp(i*x)+exp(-i*x))";
    }

    @Override
    Zahl f(Zahl x) throws JasymcaException {
        Unexakt z = x.unexakt();
        if (z.imag == 0.0) {
            return new Unexakt(Math.tan(z.real));
        }
        return (Zahl)LambdaTAN.evalx(this.trigrule, z);
    }

    @Override
    Algebraic f_exakt(Algebraic x) throws JasymcaException {
        if (x.equals(Zahl.ZERO)) {
            return Zahl.ZERO;
        }
        return null;
    }
}

