/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.FunctionVariable;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.LambdaSOLVE;
import jasymca.ParseException;
import jasymca.Polynomial;
import jasymca.Variable;
import jasymca.Vektor;
import java.util.Stack;

class LambdaSUBST
extends Lambda {
    LambdaSUBST() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = LambdaSUBST.getNarg(st);
        if (narg != 3) {
            throw new ParseException("Usage: SUBST (a, b, c), substitutes a for b in c");
        }
        Algebraic a = LambdaSUBST.getAlgebraic(st);
        Polynomial b = LambdaSUBST.getPolynomial(st);
        Algebraic c = LambdaSUBST.getAlgebraic(st);
        Variable bx = b.var;
        while (bx instanceof FunctionVariable) {
            Algebraic arg = ((FunctionVariable)bx).arg;
            if (!(arg instanceof Polynomial)) {
                throw new JasymcaException("Can not solve " + b + " for a variable.");
            }
            bx = ((Polynomial)arg).var;
        }
        Vektor sol = LambdaSOLVE.solve(a.sub(b), bx);
        Algebraic[] res = new Algebraic[sol.length()];
        for (int i = 0; i < sol.length(); ++i) {
            Algebraic y = sol.get(i);
            res[i] = c.value(bx, y);
        }
        st.push(new Vektor(res).reduce());
        return 0;
    }
}

