/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.Exakt;
import jasymca.FunctionVariable;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.Polynomial;
import jasymca.SimpleVariable;
import jasymca.SqrtExpand;
import jasymca.Unexakt;
import jasymca.Variable;
import jasymca.Zahl;
import java.math.BigInteger;

class LambdaSQRT
extends LambdaAlgebraic {
    static String intrule2 = "(2*a*x+b)*sqrt(X)/(4*a)+(4*a*c-b*b)/(8*a*sqrt(a))*log(2*sqrt(a*X)+2*a*x+b)";

    public LambdaSQRT() {
        this.diffrule = "1/(2*sqrt(x))";
        this.intrule = "2/3*x*sqrt(x)";
    }

    @Override
    public Algebraic integrate(Algebraic arg, Variable x) throws JasymcaException {
        try {
            return super.integrate(arg, x);
        }
        catch (JasymcaException je) {
            if (!arg.depends(x)) {
                throw new JasymcaException("Expression in function does not depend on Variable.");
            }
            if (!(arg instanceof Polynomial) || ((Polynomial)arg).degree() != 2 || !((Polynomial)arg).ratfunc(x)) {
                throw new JasymcaException("Can not integrate function ");
            }
            Polynomial xp = new Polynomial(x);
            Polynomial X = (Polynomial)arg;
            Algebraic y = LambdaSQRT.evalx(intrule2, xp);
            y = y.value(new SimpleVariable("X"), X);
            y = y.value(new SimpleVariable("a"), X.a[2]);
            y = y.value(new SimpleVariable("b"), X.a[1]);
            y = y.value(new SimpleVariable("c"), X.a[0]);
            y = new SqrtExpand().f_exakt(y);
            return y;
        }
    }

    @Override
    public Zahl f(Zahl x) throws JasymcaException {
        Unexakt z = x.unexakt();
        if (z.imag == 0.0) {
            if (z.real < 0.0) {
                return new Unexakt(0.0, Math.sqrt(-z.real));
            }
            return new Unexakt(Math.sqrt(z.real));
        }
        double sr = Math.sqrt(Math.sqrt(z.real * z.real + z.imag * z.imag));
        double phi = Math.atan2(z.imag, z.real) / 2.0;
        return new Unexakt(sr * Math.cos(phi), sr * Math.sin(phi));
    }

    @Override
    Algebraic f_exakt(Algebraic x) throws JasymcaException {
        if (x.equals(Zahl.ONE) || x.equals(Zahl.ZERO)) {
            return x;
        }
        if (x.equals(Zahl.MINUS)) {
            return Zahl.IONE;
        }
        if (x instanceof Zahl) {
            return this.fzexakt((Zahl)x);
        }
        if (x instanceof Polynomial && ((Polynomial)x).degree() == 1 && ((Polynomial)x).a[0].equals(Zahl.ZERO) && ((Polynomial)x).a[1].equals(Zahl.ONE) && ((Polynomial)x).var instanceof FunctionVariable && ((FunctionVariable)((Polynomial)x).var).fname.equals("exp")) {
            return FunctionVariable.create("exp", ((FunctionVariable)((Polynomial)x).var).arg.div(Zahl.TWO));
        }
        return null;
    }

    Algebraic fzexakt(Zahl x) throws JasymcaException {
        if (x instanceof Exakt && !x.komplexq()) {
            if (x.smaller(Zahl.ZERO)) {
                Algebraic r = this.fzexakt((Zahl)x.mult(Zahl.MINUS));
                if (r != null) {
                    return Zahl.IONE.mult(r);
                }
                return r;
            }
            long nom = ((Exakt)x).real[0].longValue();
            long den = ((Exakt)x).real[1].longValue();
            long a0 = this.introot(nom);
            long a1 = nom / (a0 * a0);
            long b0 = this.introot(den);
            long b1 = den / (b0 * b0);
            BigInteger[] br = new BigInteger[]{BigInteger.valueOf(a0), BigInteger.valueOf(b0 * b1)};
            Exakt r = new Exakt(br);
            a0 = a1 * b1;
            if (a0 == 1L) {
                return r;
            }
            return r.mult(new Polynomial(new FunctionVariable("sqrt", new Exakt(BigInteger.valueOf(a0)), this)));
        }
        return null;
    }

    long introot(long x) {
        long f;
        long g;
        long s = 1L;
        long[] t = new long[]{2L, 3L, 5L};
        for (int i = 0; i < t.length; ++i) {
            g = t[i];
            f = g * g;
            while (x % f == 0L && x != 1L) {
                s *= g;
                x /= f;
            }
        }
        long i = 6L;
        while (x != 1L) {
            g = i + 1L;
            f = g * g;
            while (x % f == 0L && x != 1L) {
                s *= g;
                x /= f;
            }
            g = i + 5L;
            f = g * g;
            while (x % f == 0L && x != 1L) {
                s *= g;
                x /= f;
            }
            if (f > x) break;
            i += 6L;
        }
        return s;
    }
}

