/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JH1D;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.Matrix;
import jasymca.ParseException;
import jasymca.Vektor;
import jasymca.Zahl;
import java.util.Stack;

class LambdaH1D
extends Lambda {
    LambdaH1D() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        LambdaH1D.Argjh1d(st);
        return 0;
    }

    static void Argjh1d(Stack st) throws ParseException, JasymcaException {
        Object v1;
        Algebraic m1;
        int narg = LambdaH1D.getNarg(st);
        Object a = st.pop();
        Object x = st.pop();
        Object y = st.pop();
        Object z = st.pop();
        Object data = st.pop();
        if (!(a instanceof String)) {
            throw new JasymcaException("First argument must be string.");
        }
        if (!(x instanceof Zahl)) {
            throw new JasymcaException("2nd  argument must be int.");
        }
        if (!(y instanceof Zahl)) {
            throw new JasymcaException("3rd argument must be double.");
        }
        if (!(z instanceof Zahl)) {
            throw new JasymcaException("4rd argument must be double.");
        }
        if (!(data instanceof Matrix) && !(data instanceof Vektor)) {
            throw new JasymcaException("5th argument must be Vektor or Matrix");
        }
        int bins = (int)((Zahl)x).unexakt().real;
        double x1 = (int)((Zahl)y).unexakt().real;
        double x2 = (int)((Zahl)z).unexakt().real;
        String fmt = ((String)a).trim();
        JH1D jj = new JH1D(fmt, bins, x1, x2);
        if (data instanceof Vektor) {
            m1 = (Vektor)data;
            v1 = ((Vektor)m1).getDouble();
            jj.fillD1((double[])v1);
        }
        if (data instanceof Matrix) {
            m1 = (Matrix)data;
            v1 = ((Matrix)m1).getDouble();
            jj.fillD2((double[][])v1);
        }
        st.push(jj);
    }
}

