/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.LambdaRAT;
import jasymca.ParseException;
import jasymca.Poly;
import jasymca.Polynomial;
import jasymca.Zahl;
import java.util.Stack;

class LambdaGCD
extends Lambda {
    LambdaGCD() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = LambdaGCD.getNarg(st);
        if (narg < 2) {
            throw new ParseException("GCD requires at least 2 arguments.");
        }
        Algebraic gcd = LambdaGCD.getAlgebraic(st);
        for (int i = 1; i < narg; ++i) {
            gcd = this.gcd(gcd, LambdaGCD.getAlgebraic(st));
        }
        st.push(gcd);
        return 0;
    }

    Algebraic gcd(Algebraic x, Algebraic y) throws JasymcaException {
        if (!x.exaktq()) {
            x = new LambdaRAT().f_exakt(x);
        }
        if (!y.exaktq()) {
            y = new LambdaRAT().f_exakt(y);
        }
        if (x instanceof Zahl && y instanceof Zahl) {
            return ((Zahl)x).gcd((Zahl)y);
        }
        if (x instanceof Polynomial) {
            Zahl gcd_x = ((Polynomial)x).gcd_coeff();
            if (y instanceof Polynomial) {
                Zahl gcd_y = ((Polynomial)y).gcd_coeff();
                return Poly.poly_gcd(x, y).mult(gcd_x.gcd(gcd_y));
            }
            if (y instanceof Zahl) {
                return gcd_x.gcd((Zahl)y);
            }
        }
        if (y instanceof Polynomial && x instanceof Zahl) {
            return this.gcd(y, x);
        }
        throw new JasymcaException("Not implemented.");
    }
}

