/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.Matrix;
import jasymca.ParseException;
import jasymca.Vektor;
import java.util.Stack;

class LambdaDIAG
extends Lambda {
    LambdaDIAG() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = LambdaDIAG.getNarg(st);
        if (narg < 1) {
            throw new JasymcaException("Usage: DIAG( matrix, k ).");
        }
        Algebraic x = LambdaDIAG.getAlgebraic(st).reduce();
        int k = 0;
        if (narg > 1) {
            k = LambdaDIAG.getInteger(st);
        }
        if (x.scalarq()) {
            x = new Vektor(new Algebraic[]{x});
        }
        if (x instanceof Vektor) {
            Vektor xv = (Vektor)x;
            if (k >= 0) {
                Matrix m = new Matrix(xv.length() + k, xv.length() + k);
                for (int i = 0; i < xv.length(); ++i) {
                    m.set(i, i + k, xv.get(i));
                }
                st.push(m);
                return 0;
            } else {
                Matrix m = new Matrix(xv.length() - k, xv.length() - k);
                for (int i = 0; i < xv.length(); ++i) {
                    m.set(i - k, i, xv.get(i));
                }
                st.push(m);
            }
            return 0;
        } else {
            if (!(x instanceof Matrix)) throw new JasymcaException("Argument to DIAG must be vector or matrix.");
            Matrix xm = (Matrix)x;
            if (k >= 0 && k < xm.ncol()) {
                Algebraic[] a = new Algebraic[xm.ncol() - k];
                for (int i = 0; i < a.length; ++i) {
                    a[i] = xm.get(i, i + k);
                }
                st.push(new Vektor(a));
                return 0;
            } else {
                if (k >= 0 || -k >= xm.nrow()) throw new JasymcaException("Argument k to DIAG out of range.");
                Algebraic[] a = new Algebraic[xm.nrow() + k];
                for (int i = 0; i < a.length; ++i) {
                    a[i] = xm.get(i - k, i);
                }
                st.push(new Vektor(a));
            }
        }
        return 0;
    }
}

