/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.ErrorLogger;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.Matrix;
import jasymca.ParseException;
import jasymca.Vektor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Stack;

class LambdaCSVWRITE
extends Lambda {
    LambdaCSVWRITE() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = LambdaCSVWRITE.getNarg(st);
        Object s_in = st.pop();
        if (!(s_in instanceof String)) {
            throw new JasymcaException("First argument to csvwrite must be string (filename).");
        }
        String filename = (String)s_in;
        filename = filename.trim();
        ErrorLogger.debugLine("Writing CSV>" + filename + "<");
        Object n = st.pop();
        if (!(n instanceof Matrix) && !(n instanceof Vektor)) {
            throw new JasymcaException("Second argument to csvwrite must be a Matrix or Vektor");
        }
        if (n != null && n instanceof Vektor) {
            Vektor mx = new Vektor(LambdaCSVWRITE.getAlgebraic(st));
            double[] values = mx.getDouble();
            try {
                File CSVFile = new File(filename);
                BufferedWriter outWriter = new BufferedWriter(new FileWriter(CSVFile));
                try {
                    for (int row = 0; row < values.length; ++row) {
                        outWriter.write(Double.toString(values[row]) + "\n");
                    }
                }
                catch (Exception e) {
                    new JasymcaException("CSVWRITE cannot write vector to file:" + filename);
                    ErrorLogger.debugLine("CSWRITE: function exception - " + e.getMessage());
                }
                outWriter.close();
            }
            catch (Exception e) {
                new JasymcaException("CSVWRITE cannot write file:" + e.getMessage());
            }
            return 0;
        }
        if (n != null && n instanceof Matrix) {
            Matrix mx = new Matrix(LambdaCSVWRITE.getAlgebraic(st));
            double[][] values = mx.getDouble();
            try {
                File CSVFile = new File(filename);
                BufferedWriter outWriter = new BufferedWriter(new FileWriter(CSVFile));
                try {
                    for (int row = 0; row < values.length; ++row) {
                        String line = "";
                        for (int column = 0; column < values[row].length; ++column) {
                            line = line + Double.toString(values[row][column]) + ",";
                        }
                        outWriter.write(line, 0, line.length() - 1);
                        outWriter.newLine();
                    }
                }
                catch (Exception e) {
                    new JasymcaException("CSVWRITE cannot write file:" + filename);
                    ErrorLogger.debugLine("CSVRead: load function exception - " + e.getMessage());
                }
                outWriter.close();
            }
            catch (Exception e) {
                new JasymcaException("CSVWRITE cannot write file:" + e.getMessage());
            }
        }
        return 0;
    }
}

