/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import cern.jet.stat.Probability;
import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.ParseException;
import jasymca.Unexakt;
import jasymca.Zahl;
import java.util.Stack;

class LambdaCHI2_DIST
extends Lambda {
    LambdaCHI2_DIST() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = LambdaCHI2_DIST.getNarg(st);
        if (narg != 2) {
            throw new ParseException("requires 2. Mean and sigma");
        }
        Algebraic a1 = LambdaCHI2_DIST.getAlgebraic(st);
        Algebraic a2 = LambdaCHI2_DIST.getAlgebraic(st);
        if (a1 instanceof Zahl && a2 instanceof Zahl) {
            int x1 = (int)((Zahl)a1).unexakt().real;
            double x2 = ((Zahl)a2).unexakt().real;
            double y = Probability.poisson((int)x1, (double)x2);
            st.push(new Unexakt((double)y).real);
        }
        return 0;
    }
}

