/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.CollectExp;
import jasymca.ExpandUser;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.LambdaSOLVE;
import jasymca.NormExp;
import jasymca.ParseException;
import jasymca.Polynomial;
import jasymca.Rational;
import jasymca.SqrtExpand;
import jasymca.TrigExpand;
import jasymca.Variable;
import jasymca.Vektor;
import jasymca.Zahl;
import java.util.Stack;
import java.util.Vector;

class LambdaALGSYS
extends Lambda {
    LambdaALGSYS() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = LambdaALGSYS.getNarg(st);
        if (narg != 2) {
            throw new ParseException("algsys requires 2 arguments.");
        }
        Algebraic expr = LambdaALGSYS.getAlgebraic(st).rat();
        Algebraic vars = LambdaALGSYS.getAlgebraic(st);
        if (!(expr instanceof Vektor) || !(vars instanceof Vektor) || ((Vektor)expr).length() != ((Vektor)vars).length()) {
            throw new ParseException("Wrong type of arguments to algsys.");
        }
        expr = new ExpandUser().f_exakt(expr);
        expr = new TrigExpand().f_exakt(expr);
        expr = new NormExp().f_exakt(expr);
        expr = new CollectExp(expr).f_exakt(expr);
        expr = new SqrtExpand().f_exakt(expr);
        Vector<Variable> v = new Vector<Variable>();
        for (int i = 0; i < ((Vektor)vars).length(); ++i) {
            Algebraic p = ((Vektor)vars).get(i);
            if (!(p instanceof Polynomial)) {
                throw new ParseException("Wrong type of arguments to algsys.");
            }
            v.addElement(((Polynomial)p).var);
        }
        st.push(this.solvesys(((Vektor)expr).vector(), v));
        return 0;
    }

    Vektor solvesys(Vector expr, Vector x) throws JasymcaException {
        int k;
        Variable v;
        Vector xv;
        Vector equ;
        int i;
        int n;
        int nvars = x.size();
        Vector lsg = new Vector();
        Vector<Vector> vars = new Vector<Vector>();
        lsg.addElement(expr);
        vars.addElement(x);
        for (n = nvars; n > 0; --n) {
            for (i = 0; i < lsg.size(); ++i) {
                try {
                    equ = (Vector)lsg.elementAt(i);
                    xv = (Vector)vars.elementAt(i);
                    Vektor sol = this.solve(equ, xv, n);
                    lsg.removeElementAt(i);
                    vars.removeElementAt(i);
                    v = (Variable)xv.elementAt(n - 1);
                    for (k = 0; k < sol.length(); ++k) {
                        int j;
                        Vector<Algebraic> eq = new Vector<Algebraic>();
                        for (j = 0; j < n - 1; ++j) {
                            eq.addElement(((Algebraic)equ.elementAt(j)).value(v, sol.get(k)));
                        }
                        eq.addElement(sol.get(k));
                        for (j = n; j < nvars; ++j) {
                            eq.addElement((Algebraic)equ.elementAt(j));
                        }
                        lsg.insertElementAt(eq, i);
                        vars.insertElementAt(this.clonev(xv), i);
                        ++i;
                    }
                    continue;
                }
                catch (JasymcaException je) {
                    lsg.removeElementAt(i);
                    vars.removeElementAt(i);
                    --i;
                }
            }
            if (lsg.size() != 0) continue;
            throw new JasymcaException("Could not solve equations.");
        }
        for (i = 0; i < lsg.size(); ++i) {
            equ = (Vector)lsg.elementAt(i);
            xv = (Vector)vars.elementAt(i);
            for (n = 1; n < nvars; ++n) {
                Algebraic y = (Algebraic)equ.elementAt(n - 1);
                v = (Variable)xv.elementAt(n - 1);
                for (k = n; k < nvars; ++k) {
                    Algebraic z = (Algebraic)equ.elementAt(k);
                    equ.removeElementAt(k);
                    equ.insertElementAt(z.value(v, y), k);
                }
            }
        }
        for (i = 0; i < lsg.size(); ++i) {
            equ = (Vector)lsg.elementAt(i);
            xv = (Vector)vars.elementAt(i);
            for (n = 0; n < nvars; ++n) {
                Variable v2 = (Variable)xv.elementAt(n);
                Algebraic y = new Polynomial(v2).sub((Algebraic)equ.elementAt(n));
                equ.removeElementAt(n);
                equ.insertElementAt(y, n);
            }
        }
        Algebraic[] r = new Vektor[lsg.size()];
        for (int i2 = 0; i2 < lsg.size(); ++i2) {
            r[i2] = Vektor.create((Vector)lsg.elementAt(i2));
        }
        return new Vektor(r);
    }

    Vector clonev(Vector v) {
        Vector r = new Vector(v.size());
        for (int i = 0; i < v.size(); ++i) {
            r.addElement(v.elementAt(i));
        }
        return r;
    }

    Vektor solve(Vector expr, Vector x, int n) throws JasymcaException {
        int k;
        int i;
        Algebraic equ = null;
        Variable v = null;
        int iv = 0;
        int ke = 0;
        for (i = 0; i < n && equ == null; ++i) {
            v = (Variable)x.elementAt(i);
            double norm = -1.0;
            for (k = 0; k < n; ++k) {
                double nm;
                Algebraic slope;
                Algebraic exp = (Algebraic)expr.elementAt(k);
                if (exp instanceof Rational) {
                    exp = ((Rational)exp).nom;
                }
                if ((slope = exp.deriv(v)).equals(Zahl.ZERO) || !(slope instanceof Zahl) || !((nm = slope.norm() / exp.norm()) > norm)) continue;
                norm = nm;
                equ = exp;
                ke = k;
                iv = i;
            }
        }
        if (equ == null) {
            block2: for (i = 0; i < n && equ == null; ++i) {
                v = (Variable)x.elementAt(i);
                for (k = 0; k < n; ++k) {
                    Algebraic exp = (Algebraic)expr.elementAt(k);
                    if (exp instanceof Rational) {
                        exp = ((Rational)exp).nom;
                    }
                    if (!exp.depends(v)) continue;
                    equ = exp;
                    ke = k;
                    iv = i;
                    continue block2;
                }
            }
        }
        if (equ == null) {
            throw new JasymcaException("Expressions do not depend of Variables.");
        }
        Vektor sol = LambdaSOLVE.solve(equ, v);
        expr.removeElementAt(ke);
        expr.insertElementAt(equ, n - 1);
        x.removeElementAt(iv);
        x.insertElementAt(v, n - 1);
        return sol;
    }
}

