/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.ConsoleInputStream;
import jasymca.Jasymca;
import jasymca.LambdaLOADFILE;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;

public class JasymcaConsoleText {
    private static final long serialVersionUID = 1L;
    Vector<String> history = new Vector();
    private int history_index;
    private int max_histSize = 1000;
    private ConsoleInputStream in;
    private PrintStream out;
    private Hashtable params = null;
    private Jasymca jas = null;

    public JasymcaConsoleText(InputStream inStream, PrintStream outStream) {
        this.history.addElement("");
        this.history_index = 0;
        this.params = new Hashtable();
        String ui = "Octave";
        this.jas = new Jasymca(ui);
        this.jas.setup_ui("Octave", false);
        this.jas.welcome = "Restarting in Octave mode.\n";
        this.jas.start(inStream, outStream);
    }

    public void setInput(InputStream s) {
        this.jas.start(this.in, this.out);
    }

    void back_history() {
        if (this.history_index > 0 && this.history_index <= this.history.size()) {
            --this.history_index;
            String string = this.history.elementAt(this.history_index);
        }
    }

    void forth_history() {
        if (this.history_index >= -1 && this.history_index < this.history.size() - 1) {
            ++this.history_index;
            String string = this.history.elementAt(this.history_index);
        } else if (this.history_index == this.history.size() - 1) {
            ++this.history_index;
        }
    }

    public void readScriptFile(File file) {
        if (this.jas == null) {
            return;
        }
        try {
            LambdaLOADFILE.readFile(new FileInputStream(file));
        }
        catch (Exception e) {
            this.out.println("Error reading file " + file.getName());
        }
    }

    public void readScript(File file) {
        if (this.jas == null) {
            return;
        }
        new Thread(new FileLoader(file)).start();
    }

    public void readStream(InputStream file) throws Exception {
        if (this.jas == null) {
            return;
        }
        LambdaLOADFILE.readFile(file);
    }

    public void saveHistory(File file) {
        try {
            FileOutputStream f = new FileOutputStream(file);
            for (int i = 0; i < this.history.size(); ++i) {
                f.write((this.history.elementAt(i) + "\n").getBytes());
            }
            f.close();
        }
        catch (Exception e) {
            this.out.println("Error writing file " + file.getName());
        }
    }

    public void warn_permissions() {
        this.out.println("\nReading and writing files is not allowed on this computer.");
        this.out.println("See the documentation for setting permissions.");
    }

    public void restart() {
        String ui = "Octave";
        this.jas = new Jasymca(ui);
        this.jas.start(this.in, this.out);
    }

    public PrintStream getOut() {
        return this.out;
    }

    class FileLoader
    implements Runnable {
        File file;

        public FileLoader(File file) {
            this.file = file;
        }

        @Override
        public void run() {
            try {
                LambdaLOADFILE.readFile(new FileInputStream(this.file));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

