/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.FunctionVariable;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.ParseException;
import jasymca.Zahl;
import java.util.Stack;

class FCT
extends LambdaAlgebraic {
    FCT() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = FCT.getNarg(st);
        Algebraic arg = FCT.getAlgebraic(st);
        if (arg instanceof Zahl) {
            st.push(this.f((Zahl)arg));
        } else {
            st.push(FunctionVariable.create("factorial", arg));
        }
        return 0;
    }

    @Override
    Algebraic f_exakt(Algebraic x) throws JasymcaException {
        if (x instanceof Zahl) {
            return this.f((Zahl)x);
        }
        return null;
    }

    @Override
    public Zahl f(Zahl x) throws JasymcaException {
        if (!x.integerq() || x.smaller(Zahl.ZERO)) {
            throw new JasymcaException("Argument to factorial must be a positive integer, is " + x);
        }
        Algebraic r = Zahl.ONE;
        while (Zahl.ONE.smaller(x)) {
            r = r.mult(x);
            x = (Zahl)x.sub(Zahl.ONE);
        }
        return r;
    }
}

