/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.Unexakt;
import jasymca.Zahl;
import java.math.BigInteger;
import java.util.Vector;

public class Exakt
extends Zahl {
    BigInteger[] real;
    BigInteger[] imag = null;

    public Exakt(BigInteger[] real) {
        this(real, null);
    }

    public Exakt(long nom, long den) {
        this.real = new BigInteger[2];
        this.real[0] = BigInteger.valueOf(nom);
        this.real[1] = BigInteger.valueOf(den);
    }

    public Exakt(BigInteger r) {
        this.real = new BigInteger[2];
        this.real[0] = r;
        this.real[1] = BigInteger.ONE;
    }

    public Exakt(BigInteger[] real, BigInteger[] imag) {
        this.real = this.reducev(real);
        if (imag != null && !imag[0].equals(BigInteger.ZERO)) {
            this.imag = this.reducev(imag);
        }
    }

    public Exakt(double x) {
        this(x, 0.0);
    }

    public Exakt(double x, double y) {
        this.real = this.reducev(this.double2rat(x));
        if (y != 0.0) {
            this.imag = this.reducev(this.double2rat(y));
        }
    }

    BigInteger double2big(double x) {
        int exp = 0;
        while (x > 1.0E15) {
            x /= 10.0;
            ++exp;
        }
        BigInteger y = BigInteger.valueOf(Math.round(x));
        if (exp > 0) {
            BigInteger ten = BigInteger.valueOf(10L);
            y = y.multiply(ten.pow(exp));
        }
        return y;
    }

    private BigInteger[] double2rat(double x) {
        double epstry;
        if (x == 0.0) {
            BigInteger[] br = new BigInteger[]{BigInteger.ZERO, BigInteger.ONE};
            return br;
        }
        if (x < 0.0) {
            BigInteger[] br = this.double2rat(-x);
            br[0] = br[0].negate();
            return br;
        }
        double eps = 1.0E-8;
        Zahl a = Lambda.pc.env.getnum("ratepsilon");
        if (a != null && (epstry = a.unexakt().real) > 0.0) {
            eps = epstry;
        }
        if (x < 1.0 / eps) {
            double[] y = this.cfs(x, eps);
            BigInteger[] br = new BigInteger[]{this.double2big(y[0]), this.double2big(y[1])};
            return br;
        }
        BigInteger[] br = new BigInteger[]{this.double2big(x), BigInteger.ONE};
        return br;
    }

    private double[] cfs(double x, double tol) {
        Vector<Double> a = new Vector<Double>();
        double[] y = new double[2];
        tol = Math.abs(x * tol);
        double aa = Math.floor(x);
        a.addElement(new Double(aa));
        double ra = x;
        this.cfsd(a, y);
        while (true) {
            double d;
            double error = Math.abs(x - y[0] / y[1]);
            if (!(d > tol)) break;
            ra = 1.0 / (ra - aa);
            aa = Math.floor(ra);
            a.addElement(new Double(aa));
            this.cfsd(a, y);
        }
        return y;
    }

    private void cfsd(Vector a, double[] y) {
        int i = a.size() - 1;
        double N = (Double)a.elementAt(i);
        double Z = 1.0;
        --i;
        while (i >= 0) {
            double N1 = (Double)a.elementAt(i) * N + Z;
            Z = N;
            N = N1;
            --i;
        }
        y[0] = N;
        y[1] = Z;
    }

    Exakt cfs(double tol1) throws JasymcaException {
        Vector<BigInteger> a = new Vector<BigInteger>();
        Exakt tol = (Exakt)this.mult(new Exakt(tol1));
        BigInteger aa = this.real[0].divide(this.real[1]);
        a.addElement(aa);
        Exakt y = new Exakt(this.cfs(a));
        Exakt error = (Exakt)((Exakt)this.sub(y)).abs();
        Exakt ra = this;
        while (tol.smaller(error)) {
            ra = (Exakt)Zahl.ONE.div(ra.sub(new Exakt(aa)));
            aa = ra.real[0].divide(ra.real[1]);
            a.addElement(aa);
            y = new Exakt(this.cfs(a));
            error = (Exakt)((Exakt)this.sub(y)).abs();
        }
        return y;
    }

    private BigInteger[] cfs(Vector a) throws JasymcaException {
        int i = a.size() - 1;
        BigInteger N = (BigInteger)a.elementAt(i);
        BigInteger Z = BigInteger.ONE;
        --i;
        while (i >= 0) {
            BigInteger N1 = ((BigInteger)a.elementAt(i)).multiply(N).add(Z);
            Z = N;
            N = N1;
            --i;
        }
        BigInteger[] r = new BigInteger[]{N, Z};
        return r;
    }

    private BigInteger[] reducev(BigInteger[] y) {
        BigInteger[] x = new BigInteger[]{y[0], y[1]};
        BigInteger gcd = x[0].gcd(x[1]);
        if (!gcd.equals(BigInteger.ONE)) {
            x[0] = x[0].divide(gcd);
            x[1] = x[1].divide(gcd);
        }
        if (x[1].compareTo(BigInteger.ZERO) < 0) {
            x[0] = x[0].negate();
            x[1] = x[1].negate();
        }
        return x;
    }

    @Override
    public Algebraic realpart() throws JasymcaException {
        return new Exakt(this.real);
    }

    @Override
    public Algebraic imagpart() throws JasymcaException {
        if (this.imag != null) {
            return new Exakt(this.imag);
        }
        return new Exakt(BigInteger.ZERO);
    }

    @Override
    public boolean exaktq() {
        return true;
    }

    private double floatValue(BigInteger[] x) {
        BigInteger[] q = x[0].divideAndRemainder(x[1]);
        return q[0].doubleValue() + q[1].doubleValue() / x[1].doubleValue();
    }

    public Unexakt tofloat() {
        if (this.imag == null) {
            return new Unexakt(this.floatValue(this.real));
        }
        return new Unexakt(this.floatValue(this.real), this.floatValue(this.imag));
    }

    private BigInteger[] add(BigInteger[] x, BigInteger[] y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        BigInteger[] r = new BigInteger[]{x[0].multiply(y[1]).add(y[0].multiply(x[1])), x[1].multiply(y[1])};
        return r;
    }

    private BigInteger[] sub(BigInteger[] x, BigInteger[] y) {
        if (y == null) {
            return x;
        }
        BigInteger[] r = new BigInteger[]{y[0].negate(), y[1]};
        return this.add(x, r);
    }

    private BigInteger[] mult(BigInteger[] x, BigInteger[] y) {
        if (x == null || y == null) {
            return null;
        }
        BigInteger[] r = new BigInteger[]{x[0].multiply(y[0]), x[1].multiply(y[1])};
        return r;
    }

    private BigInteger[] div(BigInteger[] x, BigInteger[] y) throws JasymcaException {
        if (x == null) {
            return null;
        }
        if (y == null) {
            throw new JasymcaException("Division by Zero.");
        }
        BigInteger[] r = new BigInteger[]{x[0].multiply(y[1]), x[1].multiply(y[0])};
        return r;
    }

    private boolean equals(BigInteger[] x, BigInteger[] y) {
        if (x == null && y == null) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x[0].equals(y[0]) && x[1].equals(y[1]);
    }

    @Override
    public Algebraic add(Algebraic x) throws JasymcaException {
        if (!(x instanceof Zahl)) {
            return x.add(this);
        }
        Exakt X = ((Zahl)x).exakt();
        return new Exakt(this.add(this.real, X.real), this.add(this.imag, X.imag));
    }

    @Override
    public Algebraic mult(Algebraic x) throws JasymcaException {
        if (!(x instanceof Zahl)) {
            return x.mult(this);
        }
        Exakt X = ((Zahl)x).exakt();
        return new Exakt(this.sub(this.mult(this.real, X.real), this.mult(this.imag, X.imag)), this.add(this.mult(this.imag, X.real), this.mult(this.real, X.imag)));
    }

    @Override
    public Algebraic div(Algebraic x) throws JasymcaException {
        if (!(x instanceof Zahl)) {
            return super.div(x);
        }
        Exakt X = ((Zahl)x).exakt();
        BigInteger[] N = this.add(this.mult(X.real, X.real), this.mult(X.imag, X.imag));
        if (N == null || N[0].equals(BigInteger.ZERO)) {
            throw new JasymcaException("Division by Zero.");
        }
        return new Exakt(this.div(this.add(this.mult(this.real, X.real), this.mult(this.imag, X.imag)), N), this.div(this.sub(this.mult(this.imag, X.real), this.mult(this.real, X.imag)), N));
    }

    private BigInteger lsm(BigInteger x, BigInteger y) {
        return x.multiply(y).divide(x.gcd(y));
    }

    @Override
    public Algebraic[] div(Algebraic q1, Algebraic[] result) throws JasymcaException {
        if (result == null) {
            result = new Algebraic[2];
        }
        if (!(q1 instanceof Zahl)) {
            result[0] = Zahl.ZERO;
            result[1] = this;
            return result;
        }
        Exakt q = ((Zahl)q1).exakt();
        if (!this.komplexq() && q.komplexq()) {
            result[0] = Zahl.ZERO;
            result[1] = this;
            return result;
        }
        if (this.komplexq() && !q.komplexq()) {
            result[0] = this.div(q);
            result[1] = Zahl.ZERO;
            return result;
        }
        if (this.komplexq() && q.komplexq()) {
            result[0] = this.imagpart().div(q.imagpart());
            result[1] = this.sub(result[0].mult(q));
            return result;
        }
        if (this.integerq() && q.integerq()) {
            BigInteger[] d = this.real[0].divideAndRemainder(q.real[0]);
            result[0] = new Exakt(d[0]);
            result[1] = new Exakt(d[1]);
            return result;
        }
        result[0] = this.div(q);
        result[1] = Zahl.ZERO;
        return result;
    }

    private String b2string(BigInteger[] x) {
        if (x[1].equals(BigInteger.ONE)) {
            return x[0].toString();
        }
        return x[0].toString() + "/" + x[1].toString();
    }

    public String toString() {
        if (this.imag == null || this.imag[0].equals(BigInteger.ZERO)) {
            return "" + this.b2string(this.real);
        }
        if (this.real[0].equals(BigInteger.ZERO)) {
            return this.b2string(this.imag) + "*i";
        }
        return "(" + this.b2string(this.real) + (this.imag[0].compareTo(BigInteger.ZERO) > 0 ? "+" : "") + this.b2string(this.imag) + "*i)";
    }

    @Override
    public boolean integerq() {
        return this.real[1].equals(BigInteger.ONE) && this.imag == null;
    }

    @Override
    public boolean smaller(Zahl x) throws JasymcaException {
        return this.unexakt().smaller(x);
    }

    @Override
    public boolean komplexq() {
        return this.imag != null && !this.imag[0].equals(BigInteger.ZERO);
    }

    @Override
    public boolean imagq() {
        return this.imag != null && !this.imag[0].equals(BigInteger.ZERO) && this.real[0].equals(BigInteger.ZERO);
    }

    @Override
    public boolean equals(Object x) {
        if (x instanceof Exakt) {
            return this.equals(this.real, ((Exakt)x).real) && this.equals(this.imag, ((Exakt)x).imag);
        }
        return this.tofloat().equals(x);
    }

    @Override
    public double norm() {
        return this.tofloat().norm();
    }

    @Override
    public Algebraic rat() {
        return this;
    }

    @Override
    public Zahl abs() {
        if (this.komplexq()) {
            return this.tofloat().abs();
        }
        BigInteger[] r = new BigInteger[]{this.real[0].compareTo(BigInteger.ZERO) < 0 ? this.real[0].negate() : this.real[0], this.real[1]};
        return new Exakt(r);
    }

    public Exakt gcd(Exakt x) throws JasymcaException {
        if (this.equals(Zahl.ZERO)) {
            return x;
        }
        if (x.equals(Zahl.ZERO)) {
            return this;
        }
        if (this.komplexq() && x.komplexq()) {
            Exakt r = ((Exakt)this.realpart()).gcd((Exakt)x.realpart());
            Exakt i = ((Exakt)this.imagpart()).gcd((Exakt)x.imagpart());
            if (r.equals(Zahl.ZERO)) {
                return (Exakt)i.mult(Zahl.IONE);
            }
            if (this.realpart().div(r).equals(this.imagpart().div(i))) {
                return (Exakt)r.add(i.mult(Zahl.IONE));
            }
            return Zahl.ONE.exakt();
        }
        if (this.komplexq() || x.komplexq()) {
            return Zahl.ONE.exakt();
        }
        return (Exakt)new Exakt(this.real[0].multiply(x.real[1]).gcd(this.real[1].multiply(x.real[0]))).div(new Exakt(this.real[1].multiply(x.real[1])));
    }

    @Override
    public int intval() {
        return this.real[0].intValue();
    }
}

