/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import org.ujmp.core.interfaces.GUIObject;

public abstract class FrameManager {
    private static final Map<GUIObject, JFrame> frames = new HashMap<GUIObject, JFrame>();

    public static final JFrame showFrame(GUIObject o) {
        JFrame frame = o.getFrame();
        frames.put(o, frame);
        frame.setVisible(true);
        return frame;
    }

    public static final Collection<JFrame> getFrameList() {
        return frames.values();
    }

    public static final Map<GUIObject, JFrame> getFrames() {
        return frames;
    }

    public static final void hideFrame(GUIObject m) {
        JFrame frame = frames.get(m);
        if (frame != null) {
            frame.setVisible(false);
        }
    }

    public static final void closeFrame(GUIObject m) {
        JFrame frame = frames.get(m);
        if (frame != null) {
            frame.setVisible(false);
            frame.dispose();
            frame = null;
            frames.put(m, null);
        }
    }

    public static final void registerFrame(GUIObject object, JFrame frame) {
        frames.put(object, frame);
    }
}

