/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ConcurrentModificationException;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.ColorUtil;
import org.ujmp.core.util.UJMPFormat;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.util.GraphicsUtil;
import org.ujmp.gui.util.UIDefaults;

public class MatrixHeatmapRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 942689931503793487L;
    private MatrixGUIObject matrixGUIObject = null;
    private static final int PADDINGX = 1;
    private static final int PADDINGY = 1;
    private final Border borderSelected = BorderFactory.createLineBorder(Color.blue, 1);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.matrixGUIObject = value instanceof MatrixGUIObject ? (MatrixGUIObject)value : (value instanceof Matrix ? (MatrixGUIObject)((Matrix)value).getGUIObject() : null);
        this.setSize(table.getColumnModel().getColumn(column).getWidth() - 1, table.getRowHeight(row) - 1);
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
            super.setBorder(this.borderSelected);
        } else {
            super.setForeground(table.getForeground());
            super.setBackground(table.getBackground());
            super.setBorder(null);
        }
        this.setFont(table.getFont());
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        block18: {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            int width = this.getWidth();
            int height = this.getHeight();
            width = width == 0 ? 1 : width;
            height = height == 0 ? 1 : height;
            try {
                if (this.matrixGUIObject != null) {
                    long totalColumn = this.matrixGUIObject.getColumnCount();
                    long totalRows = this.matrixGUIObject.getRowCount();
                    if (totalColumn < 1L || totalRows < 1L) {
                        g2d.setColor(Color.GRAY);
                        g2d.fillRect(1, 1, width - 1 - 1, height - 1 - 1);
                        g2d.setColor(Color.DARK_GRAY);
                        g2d.addRenderingHints(UIDefaults.AALIAS);
                        String s = "";
                        s = this.matrixGUIObject.getLabel() != null ? s + "[" + this.matrixGUIObject.getLabel() + "]" : s + this.matrixGUIObject.getMatrix().getClass().getSimpleName();
                        GraphicsUtil.drawString(g2d, (double)width / 2.0, (double)height / 2.0 - 1.0, 0, 0, s);
                        return;
                    }
                    int xsize = (int)Math.min(totalColumn, (long)width);
                    int ysize = (int)Math.min(totalRows, (long)height);
                    xsize = xsize == 0 ? 1 : xsize;
                    ysize = ysize == 0 ? 1 : ysize;
                    double stepsizeX = (double)totalColumn / (double)width;
                    double stepsizeY = (double)totalRows / (double)height;
                    if (stepsizeX < 1.0) {
                        stepsizeX = 1.0;
                    }
                    if (stepsizeY < 1.0) {
                        stepsizeY = 1.0;
                    }
                    BufferedImage bufferedImage = new BufferedImage(xsize, ysize, 1);
                    int[] pixels = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                    if (stepsizeX != 1.0 || stepsizeY != 1.0) {
                        int pos = 0;
                        for (int y = 0; y < ysize; ++y) {
                            for (int x = 0; x < xsize; ++x) {
                                long mx = (long)Math.floor((double)x * stepsizeX);
                                long my = (long)Math.floor((double)y * stepsizeY);
                                Color col = this.matrixGUIObject.getColorAt(my, mx);
                                if (col == null) continue;
                                pixels[pos++] = (col.getRed() << 16) + (col.getGreen() << 8) + col.getBlue();
                            }
                        }
                    } else {
                        long rowCount = this.matrixGUIObject.getRowCount();
                        long colCount = this.matrixGUIObject.getColumnCount();
                        int row = 0;
                        while ((long)row < rowCount) {
                            int col = 0;
                            while ((long)col < colCount) {
                                Color color = this.matrixGUIObject.getColorAt(row, col);
                                int pos = MatrixHeatmapRenderer.getPosition(totalColumn, row, col);
                                if (color != null) {
                                    pixels[pos] = (color.getRed() << 16) + (color.getGreen() << 8) + color.getBlue();
                                }
                                ++col;
                            }
                            ++row;
                        }
                    }
                    g2d.drawImage(bufferedImage, 1, 1, width - 1 - 1, height - 1 - 1, null);
                    if (width > 20 && this.matrixGUIObject.getRowCount() == 1 && this.matrixGUIObject.getColumnCount() == 1) {
                        Color col = this.matrixGUIObject.getColorAt(0L, 0L);
                        g2d.setColor(ColorUtil.contrastBW(col));
                        String s = UJMPFormat.getSingleLineInstance().format(this.matrixGUIObject.getValueAt(0, 0));
                        if (s != null && s.length() > 25) {
                            s = s.substring(0, 25) + "...";
                        }
                        g2d.addRenderingHints(UIDefaults.AALIAS);
                        GraphicsUtil.drawString(g2d, (double)width / 2.0, (double)height / 2.0 - 1.0, 0, 0, s);
                    } else if (width > 20) {
                        g2d.setColor(Color.DARK_GRAY);
                        g2d.addRenderingHints(UIDefaults.AALIAS);
                        String s = "";
                        s = this.matrixGUIObject.getLabel() != null ? s + "[" + this.matrixGUIObject.getLabel() + "]" : s + this.matrixGUIObject.getMatrix().getClass().getSimpleName();
                        GraphicsUtil.drawString(g2d, (double)width / 2.0, (double)height / 2.0 - 1.0, 0, 0, s);
                    }
                    break block18;
                }
                g2d.setColor(Color.GRAY);
                g2d.fillRect(1, 1, width - 1 - 1, height - 1 - 1);
            }
            catch (ConcurrentModificationException totalColumn) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static int getPosition(long totalColumn, long currentRow, long currentColumn) {
        return (int)(totalColumn * currentRow + currentColumn);
    }

    public static void paintMatrix(Graphics g, MatrixGUIObject matrix, int width, int height, int paddingX, int paddingY) {
        if (g == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.addRenderingHints(UIDefaults.AALIAS);
        if (matrix == null) {
            g2d.setColor(Color.GRAY);
            g2d.drawLine(paddingX, paddingY, width - paddingX, height - paddingY);
            g2d.drawLine(width - paddingX, paddingY, paddingX, height - paddingY);
        } else {
            g2d.translate(paddingX, paddingY);
            MatrixHeatmapRenderer.paintMatrixOriginal(g2d, matrix, width - paddingX - paddingX, height - paddingY - paddingY);
            g2d.translate(-paddingX, -paddingX);
        }
    }

    public static void paintMatrix(Graphics g, MatrixGUIObject matrix, int width, int height) {
        MatrixHeatmapRenderer.paintMatrix(g, matrix, width, height, 1, 1);
    }

    private static boolean paintMatrixOriginal(Graphics g, MatrixGUIObject matrix, int width, int height) {
        boolean wasAllDataLoaded = true;
        try {
            long cols = matrix.getColumnCount();
            long rows = matrix.getRowCount();
            width = width < 1 ? 1 : width;
            height = height < 1 ? 1 : height;
            long xSize = cols > 0L ? cols : 1L;
            long ySize = rows > 0L ? rows : 1L;
            xSize = xSize > 0L ? xSize : 1L;
            ySize = ySize > 0L ? ySize : 1L;
            long xStepSize = (long)Math.ceil((double)xSize / (double)width);
            long yStepSize = (long)Math.ceil((double)ySize / (double)height);
            int imgWidth = (int)Math.ceil((double)xSize / (double)xStepSize);
            int imgHeight = (int)Math.ceil((double)ySize / (double)yStepSize);
            imgWidth = imgWidth > 0 ? imgWidth : 1;
            imgHeight = imgHeight > 0 ? imgHeight : 1;
            BufferedImage bufferedImage = new BufferedImage(imgWidth, imgHeight, 1);
            Graphics2D g2d = (Graphics2D)g;
            Graphics2D bg = (Graphics2D)bufferedImage.getGraphics();
            bg.addRenderingHints(UIDefaults.AALIAS);
            for (long col = 0L; col < cols; col += xStepSize) {
                for (long row = 0L; row < rows; row += yStepSize) {
                    bg.setColor(matrix.getColorAt(row, col));
                    bg.fillRect((int)(col / xStepSize), (int)(row / yStepSize), 1, 1);
                    if (!wasAllDataLoaded || matrix.getValueAt(row, col) != "[loading...]") continue;
                    wasAllDataLoaded = false;
                }
            }
            g2d.drawImage(bufferedImage, 0, 0, width, height, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
            if (width > 20 && matrix.getRowCount() == 1 && matrix.getColumnCount() == 1) {
                String s = UJMPFormat.getSingleLineInstance().format(matrix.getValueAt(0, 0));
                if (s != null && s.length() > 25) {
                    s = s.substring(0, 25) + "...";
                }
                g2d.setColor(ColorUtil.contrastBW(bg.getColor()));
                GraphicsUtil.drawString(g2d, (double)width / 2.0, (double)height / 2.0 - 1.0, 0, 0, s);
            }
        }
        catch (Exception e) {
            wasAllDataLoaded = false;
            e.printStackTrace();
        }
        return wasAllDataLoaded;
    }

    public void setMatrix(MatrixGUIObject matrix) {
        this.matrixGUIObject = matrix;
    }
}

