/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import org.ujmp.gui.MatrixGUIObject;

public class PlotSettings {
    private MatrixGUIObject matrixGUIObject = null;
    private long timeLimit = 5000L;
    private int height = 600;
    private int width = 800;
    private Color axisColor = new Color(0, 0, 0, 100);
    private Color zeroAxisColor = new Color(0, 0, 0, 150);
    private Color plotBackGroundColor = new Color(216, 213, 196);
    private boolean showXAxis = true;
    private boolean showYAxis = true;
    private boolean showZeroAxis = true;
    private boolean showSelection = true;
    private boolean showPlotBackGround = true;
    private double minXValue = 0.0;
    private double maxXValue = 0.0;
    private double minYValue = -2.0;
    private double maxYValue = 2.0;
    private List<Color> plotColors = new ArrayList<Color>();
    private List<Stroke> plotStrokes = new ArrayList<Stroke>();
    private Stroke axisStroke = new BasicStroke(0.5f);
    private Stroke zeroAxisStroke = new BasicStroke(1.5f);
    public static final float[] DASHPATTERN = new float[]{2.0f, 2.0f};
    public static final Stroke DASHEDSTROKE = new BasicStroke(0.5f, 1, 1, 0.0f, DASHPATTERN, 0.0f);
    private Stroke yGridStroke = DASHEDSTROKE;
    private Stroke xGridStroke = DASHEDSTROKE;
    private Color xGridColor = new Color(255, 255, 255, 180);
    private Color yGridColor = new Color(255, 255, 255, 180);
    private Color selectionColor = new Color(150, 150, 255, 80);
    private Color selectionLineColor = new Color(80, 80, 255);
    private List<Boolean> plotTraces = new ArrayList<Boolean>();
    private boolean showXGrid = true;
    private boolean showYGrid = true;
    private boolean showRunningAverage = false;
    private int runningAverageLength = 60;
    private Color runningAverageLineColor = new Color(100, 70, 0);
    private Stroke runningAverageStroke = new BasicStroke(0.5f);

    public void setAxisColor(Color axisColor) {
        this.axisColor = axisColor;
    }

    public PlotSettings(MatrixGUIObject m) {
        this();
        this.matrixGUIObject = m;
    }

    public PlotSettings() {
        this.plotColors.add(Color.BLUE);
        this.plotColors.add(Color.RED);
        this.plotColors.add(Color.GREEN);
        this.plotColors.add(Color.YELLOW);
        this.plotColors.add(Color.BLACK);
        this.plotColors.add(Color.WHITE);
        this.plotColors.add(Color.cyan);
        this.plotColors.add(Color.MAGENTA);
        this.plotColors.add(Color.orange);
        this.plotColors.add(Color.pink);
        this.plotStrokes.add(new BasicStroke(0.5f));
        this.plotStrokes.add(new BasicStroke(0.5f));
        this.plotStrokes.add(new BasicStroke(0.5f));
        this.plotStrokes.add(new BasicStroke(0.5f));
        this.plotStrokes.add(new BasicStroke(0.5f));
        this.plotStrokes.add(new BasicStroke(0.5f));
        this.plotStrokes.add(new BasicStroke(0.5f));
        this.plotStrokes.add(new BasicStroke(0.5f));
        this.plotStrokes.add(new BasicStroke(0.5f));
        this.plotStrokes.add(new BasicStroke(0.5f));
        this.plotTraces.add(true);
        this.plotTraces.add(true);
        this.plotTraces.add(true);
        this.plotTraces.add(true);
        this.plotTraces.add(true);
        this.plotTraces.add(true);
        this.plotTraces.add(true);
        this.plotTraces.add(true);
        this.plotTraces.add(true);
        this.plotTraces.add(true);
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public MatrixGUIObject getMatrixGUIObject() {
        return this.matrixGUIObject;
    }

    public void setMatrixGUIObject(MatrixGUIObject matrixGUIObject) {
        this.matrixGUIObject = matrixGUIObject;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public boolean isShowXAxis() {
        return this.showXAxis;
    }

    public void setShowXAxis(boolean showXAxis) {
        this.showXAxis = showXAxis;
    }

    public boolean isShowYAxis() {
        return this.showYAxis;
    }

    public void setShowYAxis(boolean showYAxis) {
        this.showYAxis = showYAxis;
    }

    public Stroke getAxisStroke() {
        return this.axisStroke;
    }

    public Color getPlotBackGroundColor() {
        return this.plotBackGroundColor;
    }

    public void setPlotBackGroundColor(Color plotBackGroundColor) {
        this.plotBackGroundColor = plotBackGroundColor;
    }

    public void setAxisStroke(Stroke axisStroke) {
        this.axisStroke = axisStroke;
    }

    public boolean isShowPlotBackGround() {
        return this.showPlotBackGround;
    }

    public double getMaxXValue() {
        return this.maxXValue;
    }

    public void setMaxXValue(double maxX) {
        this.maxXValue = maxX;
    }

    public double getMaxYValue() {
        return this.maxYValue;
    }

    public void setMaxYValue(double maxY) {
        this.maxYValue = maxY;
    }

    public double getMinXValue() {
        return this.minXValue;
    }

    public void setMinXValue(double minX) {
        this.minXValue = minX;
    }

    public double getMinYValue() {
        return this.minYValue;
    }

    public void setMinYValue(double minY) {
        this.minYValue = minY;
    }

    public void setShowPlotBackGround(boolean showPlotBackGround) {
        this.showPlotBackGround = showPlotBackGround;
    }

    public double getXStepSize() {
        double xs = (this.maxXValue - this.minXValue) / (double)this.getWidth() / 2.0;
        return xs < 1.0 ? 1.0 : xs;
    }

    public double getXGridStepSize() {
        return 25.0 * (this.getMaxXValue() - this.getMinXValue()) / (double)this.getWidth();
    }

    public double getXStepCount() {
        return (this.maxXValue - this.minXValue) / this.getXStepSize();
    }

    public Stroke getXGridStroke() {
        return this.xGridStroke;
    }

    public Stroke getYGridStroke() {
        return this.yGridStroke;
    }

    public void setXGridStroke(Stroke gridStroke) {
        this.xGridStroke = gridStroke;
    }

    public void setYGridStroke(Stroke gridStroke) {
        this.yGridStroke = gridStroke;
    }

    public Color getXGridColor() {
        return this.xGridColor;
    }

    public Color getYGridColor() {
        return this.yGridColor;
    }

    public double getXFactor() {
        return (double)this.getWidth() / (this.getMaxXValue() - this.getMinXValue());
    }

    public double getYGridStepSize() {
        return 25.0 * (this.getMaxYValue() - this.getMinYValue()) / (double)this.getHeight();
    }

    public boolean isShowXGrid() {
        return this.showXGrid;
    }

    public boolean isShowYGrid() {
        return this.showYGrid;
    }

    public double getYFactor() {
        return (double)this.getHeight() / (this.getMaxYValue() - this.getMinYValue());
    }

    public boolean isShowTrace(int i) {
        return this.plotTraces.get(i);
    }

    public Stroke getTraceStroke(int t) {
        return this.plotStrokes.get(t);
    }

    public Color getTraceColor(int t) {
        return this.plotColors.get(t);
    }

    public List<Color> getPlotColors() {
        return this.plotColors;
    }

    public void setPlotColors(List<Color> plotColors) {
        this.plotColors = plotColors;
    }

    public List<Stroke> getPlotStrokes() {
        return this.plotStrokes;
    }

    public void setPlotStrokes(List<Stroke> plotStrokes) {
        this.plotStrokes = plotStrokes;
    }

    public List<Boolean> getPlotTraces() {
        return this.plotTraces;
    }

    public void setPlotTraces(List<Boolean> plotTraces) {
        this.plotTraces = plotTraces;
    }

    public void setShowXGrid(boolean showXGrid) {
        this.showXGrid = showXGrid;
    }

    public void setShowYGrid(boolean showYGrid) {
        this.showYGrid = showYGrid;
    }

    public void setXGridColor(Color gridColor) {
        this.xGridColor = gridColor;
    }

    public void setYGridColor(Color gridColor) {
        this.yGridColor = gridColor;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(long timeLimit) {
        this.timeLimit = timeLimit;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
    }

    public boolean isShowSelection() {
        return this.showSelection;
    }

    public Color getSelectionLineColor() {
        return this.selectionLineColor;
    }

    public void setSelectionLineColor(Color selectionLineColor) {
        this.selectionLineColor = selectionLineColor;
    }

    public void setShowSelection(boolean showSelection) {
        this.showSelection = showSelection;
    }

    public boolean isShowZeroAxis() {
        return this.showZeroAxis;
    }

    public void setShowZeroAxis(boolean showZeroAxis) {
        this.showZeroAxis = showZeroAxis;
    }

    public Color getZeroAxisColor() {
        return this.zeroAxisColor;
    }

    public void setZeroAxisColor(Color zeroAxisColor) {
        this.zeroAxisColor = zeroAxisColor;
    }

    public Stroke getZeroAxisStroke() {
        return this.zeroAxisStroke;
    }

    public void setZeroAxisStroke(Stroke zeroAxisStroke) {
        this.zeroAxisStroke = zeroAxisStroke;
    }

    public boolean isShowRunningAverage() {
        return this.showRunningAverage;
    }

    public int getRunningAverageLength() {
        return this.runningAverageLength;
    }

    public Color getRunningAverageLineColor() {
        return this.runningAverageLineColor;
    }

    public Stroke getRunningAverageStroke() {
        return this.runningAverageStroke;
    }

    public void setShowRunningAverage(boolean showRunningAverage) {
        this.showRunningAverage = showRunningAverage;
    }

    public void setRunningAverageLength(int runningAverageLength) {
        this.runningAverageLength = runningAverageLength;
    }

    public void setRunningAverageLineColor(Color runningAverageLineColor) {
        this.runningAverageLineColor = runningAverageLineColor;
    }

    public void setRunningAverageStroke(Stroke runningAverageStroke) {
        this.runningAverageStroke = runningAverageStroke;
    }
}

