/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ujmp.core.treematrix.TreeMatrix;
import org.ujmp.core.util.ColorUtil;
import org.ujmp.core.util.Sortable;
import org.ujmp.gui.panels.AbstractPanel;

class UnbufferedMatrixTreemapPanel
extends AbstractPanel
implements MouseListener {
    private static final long serialVersionUID = -535908084636801903L;
    private final TreeMatrix<?> treeMatrix;

    public UnbufferedMatrixTreemapPanel(TreeMatrix<?> matrix) {
        super(matrix.getGUIObject());
        this.treeMatrix = matrix;
        this.setPreferredSize(new Dimension(600, 400));
        this.addMouseListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        Object root = this.treeMatrix.getRoot();
        List children = this.treeMatrix.getChildren(root);
        ArrayList<Sortable<Long, Object>> childCounts = new ArrayList<Sortable<Long, Object>>();
        for (Object child : children) {
            long count = this.treeMatrix.getChildCountRecursive(child);
            Sortable s = new Sortable(1L + count, child);
            childCounts.add(s);
        }
        Collections.sort(childCounts);
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintTreeRect(g, childCounts, 0, 0, this.getWidth(), this.getHeight());
    }

    private void paintTreeRect(Graphics g, List<Sortable<Long, Object>> childCounts, int x, int y, int width, int height) {
        if (width <= 2 || height <= 2) {
            return;
        }
        if (childCounts.isEmpty()) {
            g.setColor(Color.black);
            g.drawRect(x + 1, y + 1, width - 1, height - 1);
        } else if (childCounts.size() == 1) {
            Sortable<Long, Object> s = childCounts.remove(childCounts.size() - 1);
            if (s.getComparable() > 1L) {
                ArrayList<Sortable<Long, Object>> subChildCounts = new ArrayList<Sortable<Long, Object>>();
                List children = this.treeMatrix.getChildren(s.getObject());
                for (Object child : children) {
                    long count = this.treeMatrix.getChildCountRecursive(child);
                    s = new Sortable(1L + count, child);
                    subChildCounts.add(s);
                }
                Collections.sort(subChildCounts);
                this.paintTreeRect(g, subChildCounts, x, y, width, height);
            } else {
                g.setColor(ColorUtil.fromObject(s.getObject()));
                g.fillRect(x + 1, y + 1, width - 1, height - 1);
            }
        } else {
            long sum = 0L;
            for (Sortable<Long, Object> s : childCounts) {
                sum += s.getComparable().longValue();
            }
            Sortable<Long, Object> s = childCounts.remove(childCounts.size() - 1);
            double factor = (double)s.getComparable().longValue() / (double)sum;
            if (width > height) {
                int w = (int)((double)width * factor);
                if (s.getComparable() > 1L) {
                    ArrayList<Sortable<Long, Object>> subChildCounts = new ArrayList<Sortable<Long, Object>>();
                    List children = this.treeMatrix.getChildren(s.getObject());
                    for (Object child : children) {
                        long count = this.treeMatrix.getChildCountRecursive(child);
                        s = new Sortable(1L + count, child);
                        subChildCounts.add(s);
                    }
                    Collections.sort(subChildCounts);
                    this.paintTreeRect(g, subChildCounts, x, y, w, height);
                } else {
                    g.setColor(ColorUtil.fromObject(s.getObject()));
                    g.fillRect(x + 1, y + 1, w - 1, height - 1);
                }
                this.paintTreeRect(g, childCounts, x + w, y, width - w, height);
            } else {
                int h = (int)((double)height * factor);
                if (s.getComparable() > 1L) {
                    ArrayList<Sortable<Long, Object>> subChildCounts = new ArrayList<Sortable<Long, Object>>();
                    List children = this.treeMatrix.getChildren(s.getObject());
                    for (Object child : children) {
                        long count = this.treeMatrix.getChildCountRecursive(child);
                        s = new Sortable(1L + count, child);
                        subChildCounts.add(s);
                    }
                    Collections.sort(subChildCounts);
                    this.paintTreeRect(g, subChildCounts, x, y, width, h);
                } else {
                    g.setColor(ColorUtil.fromObject(s.getObject()));
                    g.fillRect(x + 1, y + 1, width - 1, h - 1);
                }
                this.paintTreeRect(g, childCounts, x, y + h, width, height - h);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        System.out.println(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

