/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.panels.AbstractPanel;
import org.ujmp.gui.util.UIDefaults;

public class GraphPanel
extends AbstractPanel {
    private static final long serialVersionUID = 4424717069537457440L;

    public GraphPanel(MatrixGUIObject o) {
        super(o);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.addRenderingHints(UIDefaults.AALIAS);
        MatrixGUIObject m = (MatrixGUIObject)this.getGUIObject();
        int totalCount = m.getColumnCount();
        Color color = new Color(0, 0, 200, 128);
        int size = this.getCircleSize(totalCount);
        int xCount = this.getSize().width / size;
        for (int index = 0; index < totalCount; ++index) {
            g2d.setColor(color);
            g2d.fillOval(size * (index % xCount), size * (index / xCount), size / 2, size / 2);
        }
        for (long[] c : m.getMatrix().availableCoordinates()) {
            g2d.setColor(color);
            g2d.drawLine((int)((long)size * (c[0] % (long)xCount)), (int)((long)size * (c[0] / (long)xCount)), (int)((long)size * (c[1] % (long)xCount)), (int)((long)size * (c[1] / (long)xCount)));
        }
    }

    public final int getXPos(int totalCount, int index) {
        return this.getSize().height / totalCount * index;
    }

    public final int getCircleSize(int totalCount) {
        int area = this.getSize().height * this.getSize().width;
        int size = (int)(Math.sqrt(area) / Math.sqrt(totalCount) / 1.1);
        size = Math.max(size, 1);
        return size;
    }
}

