/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.actions;

import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.ujmp.core.Coordinates;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.SparseDoubleMatrix2D;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.gui.actions.AbstractObjectAction;
import org.ujmp.gui.util.GUIUtil;

public class NewMatrixAction
extends AbstractObjectAction {
    private static final long serialVersionUID = 1875202202123788470L;

    public NewMatrixAction(JComponent c, GUIObject o) {
        super(c, o);
        this.putValue("Name", "New Matrix...");
        this.putValue("ShortDescription", "Creates a new empty matrix");
        this.putValue("MnemonicKey", 78);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 128));
    }

    @Override
    public Object call() {
        try {
            boolean isDense = GUIUtil.getBoolean("Should the matrix be dense?");
            ValueType valueType = ValueType.values()[JOptionPane.showOptionDialog(this.getComponent(), "Select the value type for the new matrix", "Sparse Matrix", 0, 3, null, (Object[])ValueType.values(), (Object)ValueType.DOUBLE)];
            long[] size = null;
            while (size == null || size.length < 2) {
                String s = JOptionPane.showInputDialog(this.getComponent(), "Enter the size of the new matrix, e.g. 3x5x6", "Dense Matrix", 3);
                try {
                    size = Coordinates.parseString(s);
                }
                catch (Exception exception) {}
            }
            Object m = null;
            switch (valueType) {
                case DOUBLE: {
                    if (isDense) {
                        m = DenseDoubleMatrix2D.Factory.zeros(size);
                        break;
                    }
                    m = SparseDoubleMatrix2D.Factory.zeros(size);
                    break;
                }
                default: {
                    throw new RuntimeException("not implemented");
                }
            }
            return m;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

