/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.matrices;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.TreeMap;
import org.ujmp.core.Matrix;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.util.NetworkUtil;
import org.ujmp.core.util.concurrent.BackgroundTask;
import org.ujmp.core.util.matrices.HttpMatrix;

public class RemoteHostMatrix
extends DefaultMapMatrix<String, Matrix> {
    private static final long serialVersionUID = 7209155858904976010L;

    public RemoteHostMatrix(final String address) {
        super(new TreeMap());
        this.setLabel(NetworkUtil.getHostName(address));
        new BackgroundTask(new Object[0]){

            @Override
            public Object run() {
                return this.searchServices();
            }

            private Object searchServices() {
                Socket socket2;
                boolean portAvailable = false;
                int delay = 3000;
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 10413), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("JDMP", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket2) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 80), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("HTTP", new HttpMatrix("http://" + this.getObject(0)));
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket3) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 443), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("HTTPS", new HttpMatrix("https://" + this.getObject(0)));
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket4) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 3306), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("MySQL", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket5) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 22), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("SSH", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket6) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 20), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("FTP", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket7) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 23), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("Telnet", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket8) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 445), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("SMB", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket9) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 1433), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("MSSQL", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket10) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 5432), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("PostgreSQL", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket11) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 11211), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("memcached", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket12) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 27017), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("mongoDB", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket13) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 25), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("SMTP", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket14) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 143), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("IMAP", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket15) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 993), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("IMAPS", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket16) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 2049), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("NFS", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket17) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 8080), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("Tomcat", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket18) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 50010), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("HDFS DataNode", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket19) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 50070), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("HDFS NameNode", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket20) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 50090), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("HDFS Secondary NameNode", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket21) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 8021), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("Hadoop JobTracker", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket22) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 50030), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("Hadoop JobTracker", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket23) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 50060), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("Hadoop TaskTracker", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket24) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 9200), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("Elasticsearch HTTP", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception socket25) {
                    // empty catch block
                }
                try {
                    socket2 = new Socket();
                    socket2.connect(new InetSocketAddress(address, 9300), 3000);
                    portAvailable = socket2.isConnected();
                    socket2.close();
                    if (portAvailable) {
                        RemoteHostMatrix.this.put("Elasticsearch Transport", null);
                        RemoteHostMatrix.this.fireValueChanged();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        };
    }
}

