/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.matrices;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.stringmatrix.impl.DefaultDenseStringMatrix2D;

public class MatrixLibraries
extends DefaultDenseStringMatrix2D {
    private static final long serialVersionUID = -2575195318248762416L;
    public static final int VERSION = 0;
    public static final int DATE = 1;
    public static final int LICENSE = 2;
    public static final int JAVA14 = 3;
    public static final int JAVA5 = 4;
    public static final int JAVA6 = 5;
    public static final int JAVA7 = 6;
    public static final int JAVA8 = 7;
    public static final int DENSESA = 8;
    public static final int DENSEAA = 9;
    public static final int DENSEBLOCK = 10;
    public static final int SPARSEDOK = 11;
    public static final int SPARSELIL = 12;
    public static final int SPARSEYALE = 13;
    public static final int SPARSECRSCCS = 14;
    public static final int SPARSECDS = 15;
    public static final int DOUBLE = 16;
    public static final int FLOAT = 17;
    public static final int BIGDECIMAL = 18;
    public static final int STRINGS = 19;
    public static final int OBJECTS = 20;
    public static final int GENERICS = 21;
    public static final int COMPLEX = 22;
    public static final int D2 = 23;
    public static final int D3 = 24;
    public static final int D3PLUS = 25;
    public static final int MULTITHREADED = 26;
    public static final int INPLACE = 27;
    public static final int TRANSPOSE = 28;
    public static final int SCALE = 29;
    public static final int PLUSMINUS = 30;
    public static final int INV = 31;
    public static final int SOLVE = 32;
    public static final int LU = 33;
    public static final int QR = 34;
    public static final int SVD = 35;
    public static final int CHOL = 36;
    public static final int EIG = 37;
    public static final int CSVIO = 38;
    public static final int JDBCIO = 39;
    public static final int SERIALIZABLE = 40;
    public static final int VALUESPERDIMENSION = 41;
    public static final int MAXIMUMSIZE = 42;
    public static final int HOMEPAGE = 43;
    public static final int COLT = MatrixLibrary.Colt.ordinal();
    public static final int COMMONSMATH = MatrixLibrary.CommonsMath.ordinal();
    public static final int EJML = MatrixLibrary.EJML.ordinal();
    public static final int JAMA = MatrixLibrary.JAMA.ordinal();
    public static final int JBLAS = MatrixLibrary.jblas.ordinal();
    public static final int JLINALG = MatrixLibrary.JlinAlg.ordinal();
    public static final int JMATHARRAY = MatrixLibrary.JMathArray.ordinal();
    public static final int JMATRICES = MatrixLibrary.JMatrices.ordinal();
    public static final int JSCI = MatrixLibrary.Jsci.ordinal();
    public static final int JSCIENCE = MatrixLibrary.Jscience.ordinal();
    public static final int LA4J = MatrixLibrary.la4j.ordinal();
    public static final int MANTISSA = MatrixLibrary.Mantissa.ordinal();
    public static final int MTJ = MatrixLibrary.MTJ.ordinal();
    public static final int OJALGO = MatrixLibrary.ojAlgo.ordinal();
    public static final int PARALLELCOLT = MatrixLibrary.ParallelColt.ordinal();
    public static final int SST = MatrixLibrary.SST.ordinal();
    public static final int UJMP = MatrixLibrary.UJMP.ordinal();
    public static final int VECMATH = MatrixLibrary.VecMath.ordinal();
    public static final String NONSINGULARLETTER = "n";
    public static final String NONSINGULARTEXT = "non-singular matrices only";
    public static final String ERRORTEXT = "error in implementation";
    public static final String SYMMETRICTEXT = "symmetric matrices only";
    private List<String> footnotes = new ArrayList<String>();
    private MatrixLibrariesFormat format = MatrixLibrariesFormat.DEFAULT;

    public MatrixLibraries() {
        this(MatrixLibrariesFormat.DEFAULT);
    }

    public MatrixLibraries(MatrixLibrariesFormat format) {
        super(44, 18);
        int footnoteId = 1;
        this.format = format;
        this.setColumnLabel(COLT, this.rotate("Colt"));
        this.setColumnLabel(COMMONSMATH, this.rotate("Commons Math"));
        this.setColumnLabel(EJML, this.rotate("EJML"));
        this.setColumnLabel(JAMA, this.rotate("JAMA"));
        this.setColumnLabel(JBLAS, this.rotate("jblas"));
        this.setColumnLabel(JLINALG, this.rotate("JLinAlg"));
        this.setColumnLabel(JMATHARRAY, this.rotate("JMathArray"));
        this.setColumnLabel(JMATRICES, this.rotate("JMatrices"));
        this.setColumnLabel(JSCI, this.rotate("JSci"));
        this.setColumnLabel(JSCIENCE, this.rotate("JScience"));
        this.setColumnLabel(LA4J, this.rotate("la4j"));
        this.setColumnLabel(MANTISSA, this.rotate("Mantissa"));
        this.setColumnLabel(MTJ, this.rotate("MTJ"));
        this.setColumnLabel(OJALGO, this.rotate("ojAlgo"));
        this.setColumnLabel(PARALLELCOLT, this.rotate("Parallel Colt"));
        this.setColumnLabel(SST, this.rotate("SST"));
        this.setColumnLabel(UJMP, this.rotate("UJMP"));
        this.setColumnLabel(VECMATH, this.rotate("vecmath"));
        this.setString(this.link(this.rotate("Colt Homepage"), "http://acs.lbl.gov/software/colt/"), 43, COLT);
        this.setString(this.link(this.rotate("Commons Math Homepage"), "http://commons.apache.org/math/"), 43, COMMONSMATH);
        this.setString(this.link(this.rotate("EJML Homepage"), "https://code.google.com/p/efficient-java-matrix-library/"), 43, EJML);
        this.setString(this.link(this.rotate("JAMA Homepage"), "http://math.nist.gov/javanumerics/jama/"), 43, JAMA);
        this.setString(this.link(this.rotate("jblas Homepage"), "http://mikiobraun.github.io/jblas/"), 43, JBLAS);
        this.setString(this.link(this.rotate("JLinAlg Homepage"), "http://jlinalg.sourceforge.net/"), 43, JLINALG);
        this.setString(this.link(this.rotate("JMathArray Homepage"), "https://code.google.com/p/jmatharray/"), 43, JMATHARRAY);
        this.setString(this.link(this.rotate("JMatrices Homepage"), "http://jmatrices.sourceforge.net/"), 43, JMATRICES);
        this.setString(this.link(this.rotate("JSci Homepage"), "http://jsci.sourceforge.net/"), 43, JSCI);
        this.setString(this.link(this.rotate("JScience Homepage"), "http://jscience.org/"), 43, JSCIENCE);
        this.setString(this.link(this.rotate("la4j Homepage"), "http://la4j.org/"), 43, LA4J);
        this.setString(this.link(this.rotate("Mantissa Homepage"), "http://www.spaceroots.org/software/mantissa/index.html"), 43, MANTISSA);
        this.setString(this.link(this.rotate("MTJ Homepage"), "https://github.com/fommil/matrix-toolkits-java/"), 43, MTJ);
        this.setString(this.link(this.rotate("ojAlgo Homepage"), "http://ojalgo.org/"), 43, OJALGO);
        this.setString(this.link(this.rotate("Parallel Colt Homepage"), "https://sites.google.com/site/piotrwendykier/software/parallelcolt"), 43, PARALLELCOLT);
        this.setString(this.link(this.rotate("SST Homepage"), "http://freecode.com/projects/shared"), 43, SST);
        this.setString(this.link(this.rotate("UJMP Homepage"), "http://ujmp.org/"), 43, UJMP);
        this.setString(this.link(this.rotate("vecmath Homepage"), "https://java.net/projects/vecmath"), 43, VECMATH);
        this.setRowLabel(0L, "Current Version");
        this.setRowLabel(1L, "Latest Release");
        this.setRowLabel(2L, "License");
        this.setRowLabel(3L, "Supports Java 1.4");
        this.setRowLabel(4L, "Supports Java 5");
        this.setRowLabel(5L, "Supports Java 6");
        this.setRowLabel(6L, "Supports Java 7");
        this.setRowLabel(7L, "Supports Java 8");
        this.setRowLabel(26L, "Uses Multi-Threaded Operations");
        this.setRowLabel(27L, "Supports In-Place Operations");
        this.setRowLabel(8L, "Stores Dense Data in Single Array");
        this.setRowLabel(9L, "Stores Dense Data in 2D Array");
        this.setRowLabel(10L, "Stores Dense Data in Block Storage");
        this.setRowLabel(11L, "Stores Sparse Data in DOK" + this.footnote("" + footnoteId++, "dictionary of key-value pairs"));
        this.setRowLabel(12L, "Stores Sparse Data in LIL" + this.footnote("" + footnoteId++, "list of lists"));
        this.setRowLabel(14L, "Stores Sparse Data in CRS/CCS" + this.footnote("" + footnoteId++, "compressed sparse row/column storare"));
        this.setRowLabel(15L, "Stores Sparse Data in CDS" + this.footnote("" + footnoteId++, "compressed sparse diagonal"));
        this.setRowLabel(13L, "Stores Sparse Data in Yale Format");
        this.setRowLabel(22L, "Can Store Complex Numbers");
        this.setRowLabel(16L, "Can Store Double Values");
        this.setRowLabel(17L, "Can Store Float Values");
        this.setRowLabel(18L, "Can Store BigDecimal Values");
        this.setRowLabel(19L, "Can Store Strings");
        this.setRowLabel(20L, "Can Store Objects");
        this.setRowLabel(21L, "Can Store Generic Objects");
        this.setRowLabel(23L, "Supports 2D Matrix");
        this.setRowLabel(24L, "Supports 3D Matrix");
        this.setRowLabel(25L, "Supports >3D Matrix");
        this.setRowLabel(28L, "Supports Matrix Transpose");
        this.setRowLabel(29L, "Supports Matrix Multiply/Divide");
        this.setRowLabel(30L, "Supports Plus/Minus");
        this.setRowLabel(31L, "Supports Matrix Inverse");
        this.setRowLabel(32L, "Supports Solve Linear System");
        this.setRowLabel(35L, "Supports Singular Value Decomposition");
        this.setRowLabel(33L, "Supports LU Decomposition");
        this.setRowLabel(34L, "Supports QR Decomposition");
        this.setRowLabel(36L, "Supports Cholesky Decomposition");
        this.setRowLabel(37L, "Supports Eigen Decomposition");
        this.setRowLabel(38L, "Can Import/Export CSV");
        this.setRowLabel(39L, "Can Import/Export JDBC");
        this.setRowLabel(40L, "Matrix is Serializable");
        this.setRowLabel(41L, "Number of Values per Dimension");
        this.setRowLabel(42L, "Maximum Matrix Size");
        this.setRowLabel(43L, "Homepage");
        this.setString("0.3.0", 0, UJMP);
        this.setString(this.small("2014"), 1, UJMP);
        this.setString(this.small("LGPL"), 2, UJMP);
        this.setString(this.no(), 3, UJMP);
        this.setString(this.yes(), 4, UJMP);
        this.setString(this.yes(), 5, UJMP);
        this.setString(this.yes(), 6, UJMP);
        this.setString(this.yes(), 7, UJMP);
        this.setString(this.yes(), 26, UJMP);
        this.setString(this.yes(), 27, UJMP);
        this.setString(this.yes(), 9, UJMP);
        this.setString(this.yes(), 8, UJMP);
        this.setString(this.yes(), 10, UJMP);
        this.setString(this.yes(), 11, UJMP);
        this.setString(this.no(), 13, UJMP);
        this.setString(this.yes(), 12, UJMP);
        this.setString(this.no(), 14, UJMP);
        this.setString(this.no(), 15, UJMP);
        this.setString(this.yes(), 16, UJMP);
        this.setString(this.yes(), 17, UJMP);
        this.setString(this.yes(), 18, UJMP);
        this.setString(this.yes(), 19, UJMP);
        this.setString(this.yes(), 20, UJMP);
        this.setString(this.yes(), 21, UJMP);
        this.setString(this.no(), 22, UJMP);
        this.setString(this.yes(), 23, UJMP);
        this.setString(this.yes(), 24, UJMP);
        this.setString(this.yes(), 25, UJMP);
        this.setString(this.yes(), 28, UJMP);
        this.setString(this.yes(), 29, UJMP);
        this.setString(this.yes(), 30, UJMP);
        this.setString(this.yes(), 31, UJMP);
        this.setString(this.squareTall(), 32, UJMP);
        this.setString(this.yes(), 36, UJMP);
        this.setString(this.yes(), 37, UJMP);
        this.setString(this.all(), 33, UJMP);
        this.setString(this.squareTall(), 34, UJMP);
        this.setString(this.all(), 35, UJMP);
        this.setString(this.yes(), 38, UJMP);
        this.setString(this.yes(), 39, UJMP);
        this.setString(this.yes(), 40, UJMP);
        this.setString(this.bit64(), 41, UJMP);
        this.setString(this.hdd(), 42, UJMP);
        this.setString(this.small("1.2.0"), 0, COLT);
        this.setString(this.small("2004"), 1, COLT);
        this.setString(this.small("BSD"), 2, COLT);
        this.setString(this.yes(), 3, COLT);
        this.setString(this.yes(), 4, COLT);
        this.setString(this.yes(), 5, COLT);
        this.setString(this.yes(), 6, COLT);
        this.setString(this.yes(), 7, COLT);
        this.setString(this.no(), 26, COLT);
        this.setString(this.yes(), 27, COLT);
        this.setString(this.yes() + this.footnote("f", "flags matrix as transposed"), 28, COLT);
        this.setString(this.yes(), 29, COLT);
        this.setString(this.yes(), 30, COLT);
        this.setString(this.yes(), 8, COLT);
        this.setString(this.no(), 9, COLT);
        this.setString(this.no(), 10, COLT);
        this.setString(this.yes(), 11, COLT);
        this.setString(this.no(), 13, COLT);
        this.setString(this.no(), 12, COLT);
        this.setString(this.no(), 14, COLT);
        this.setString(this.no(), 15, COLT);
        this.setString(this.yes(), 16, COLT);
        this.setString(this.no(), 17, COLT);
        this.setString(this.no(), 18, COLT);
        this.setString(this.yes(), 19, COLT);
        this.setString(this.yes(), 20, COLT);
        this.setString(this.no(), 21, COLT);
        this.setString(this.no(), 22, COLT);
        this.setString(this.yes(), 23, COLT);
        this.setString(this.yes(), 24, COLT);
        this.setString(this.no(), 25, COLT);
        this.setString(this.yes(), 31, COLT);
        this.setString(this.squareTall(), 32, COLT);
        this.setString(this.all(), 35, COLT);
        this.setString(this.squareTall(), 33, COLT);
        this.setString(this.squareTall(), 34, COLT);
        this.setString(this.yes(), 37, COLT);
        this.setString(this.yes(), 36, COLT);
        this.setString(this.no(), 38, COLT);
        this.setString(this.no(), 39, COLT);
        this.setString(this.yes(), 40, COLT);
        this.setString(this.no(), 38, COLT);
        this.setString(this.no(), 39, COLT);
        this.setString(this.yes(), 40, COLT);
        this.setString(this.bit32(), 41, COLT);
        this.setString(this.singleArray(), 42, COLT);
        this.setString(this.small("3.2"), 0, COMMONSMATH);
        this.setString(this.small("2013"), 1, COMMONSMATH);
        this.setString(this.small("Apache"), 2, COMMONSMATH);
        this.setString(this.no(), 3, COMMONSMATH);
        this.setString(this.yes(), 4, COMMONSMATH);
        this.setString(this.yes(), 5, COMMONSMATH);
        this.setString(this.yes(), 6, COMMONSMATH);
        this.setString(this.yes(), 7, COMMONSMATH);
        this.setString(this.no(), 26, COMMONSMATH);
        this.setString(this.yes(), 27, COMMONSMATH);
        this.setString(this.yes(), 28, COMMONSMATH);
        this.setString(this.yes(), 29, COMMONSMATH);
        this.setString(this.yes(), 30, COMMONSMATH);
        this.setString(this.yes(), 9, COMMONSMATH);
        this.setString(this.no(), 8, COMMONSMATH);
        this.setString(this.yes(), 10, COMMONSMATH);
        this.setString(this.yes(), 11, COMMONSMATH);
        this.setString(this.no(), 13, COMMONSMATH);
        this.setString(this.no(), 12, COMMONSMATH);
        this.setString(this.no(), 14, COMMONSMATH);
        this.setString(this.no(), 15, COMMONSMATH);
        this.setString(this.yes(), 16, COMMONSMATH);
        this.setString(this.no(), 17, COMMONSMATH);
        this.setString(this.yes(), 18, COMMONSMATH);
        this.setString(this.yes(), 19, COMMONSMATH);
        this.setString(this.yes(), 20, COMMONSMATH);
        this.setString(this.yes(), 21, COMMONSMATH);
        this.setString(this.yes(), 22, COMMONSMATH);
        this.setString(this.yes(), 23, COMMONSMATH);
        this.setString(this.no(), 24, COMMONSMATH);
        this.setString(this.no(), 25, COMMONSMATH);
        this.setString(this.yes(), 31, COMMONSMATH);
        this.setString(this.squareTall(), 32, COMMONSMATH);
        this.setString(this.all(), 35, COMMONSMATH);
        this.setString(this.square() + this.footnote(NONSINGULARLETTER, NONSINGULARTEXT), 33, COMMONSMATH);
        this.setString(this.all(), 34, COMMONSMATH);
        this.setString(this.yes() + this.footnote("s", SYMMETRICTEXT), 37, COMMONSMATH);
        this.setString(this.yes(), 36, COMMONSMATH);
        this.setString(this.no(), 38, COMMONSMATH);
        this.setString(this.no(), 39, COMMONSMATH);
        this.setString(this.yes(), 40, COMMONSMATH);
        this.setString(this.bit32(), 41, COMMONSMATH);
        this.setString(this.ram(), 42, COMMONSMATH);
        this.setString(this.small("0.25"), 0, EJML);
        this.setString(this.small("2014"), 1, EJML);
        this.setString(this.small("Apache"), 2, EJML);
        this.setString(this.no(), 3, EJML);
        this.setString(this.no(), 4, EJML);
        this.setString(this.yes(), 5, EJML);
        this.setString(this.yes(), 6, EJML);
        this.setString(this.yes(), 7, EJML);
        this.setString(this.no(), 26, EJML);
        this.setString(this.yes(), 27, EJML);
        this.setString(this.yes(), 8, EJML);
        this.setString(this.no(), 9, EJML);
        this.setString(this.yes(), 10, EJML);
        this.setString(this.no(), 11, EJML);
        this.setString(this.no(), 13, EJML);
        this.setString(this.no(), 12, EJML);
        this.setString(this.no(), 14, EJML);
        this.setString(this.no(), 15, EJML);
        this.setString(this.yes(), 16, EJML);
        this.setString(this.no(), 17, EJML);
        this.setString(this.no(), 18, EJML);
        this.setString(this.no(), 19, EJML);
        this.setString(this.no(), 20, EJML);
        this.setString(this.no(), 21, EJML);
        this.setString(this.no(), 22, EJML);
        this.setString(this.yes(), 23, EJML);
        this.setString(this.no(), 24, EJML);
        this.setString(this.no(), 25, EJML);
        this.setString(this.yes(), 28, EJML);
        this.setString(this.yes(), 29, EJML);
        this.setString(this.yes(), 30, EJML);
        this.setString(this.yes(), 31, EJML);
        this.setString(this.squareTall(), 32, EJML);
        this.setString(this.all(), 35, EJML);
        this.setString(this.all(), 33, EJML);
        this.setString(this.square(), 34, EJML);
        this.setString(this.yes(), 37, EJML);
        this.setString(this.yes() + this.footnote("e", ERRORTEXT), 36, EJML);
        this.setString(this.no(), 38, EJML);
        this.setString(this.no(), 39, EJML);
        this.setString(this.yes(), 40, EJML);
        this.setString(this.bit32(), 41, EJML);
        this.setString(this.singleArray(), 42, EJML);
        this.setString(this.small("1.0.3"), 0, JAMA);
        this.setString(this.small("2012"), 1, JAMA);
        this.setString(this.small("PD"), 2, JAMA);
        this.setString(this.yes(), 3, JAMA);
        this.setString(this.yes(), 4, JAMA);
        this.setString(this.yes(), 5, JAMA);
        this.setString(this.yes(), 6, JAMA);
        this.setString(this.yes(), 7, JAMA);
        this.setString(this.no(), 26, JAMA);
        this.setString(this.no(), 27, JAMA);
        this.setString(this.yes(), 9, JAMA);
        this.setString(this.no(), 8, JAMA);
        this.setString(this.no(), 10, JAMA);
        this.setString(this.no(), 11, JAMA);
        this.setString(this.no(), 13, JAMA);
        this.setString(this.no(), 12, JAMA);
        this.setString(this.no(), 14, JAMA);
        this.setString(this.no(), 15, JAMA);
        this.setString(this.yes(), 16, JAMA);
        this.setString(this.no(), 17, JAMA);
        this.setString(this.no(), 18, JAMA);
        this.setString(this.no(), 19, JAMA);
        this.setString(this.no(), 20, JAMA);
        this.setString(this.no(), 21, JAMA);
        this.setString(this.no(), 22, JAMA);
        this.setString(this.yes(), 23, JAMA);
        this.setString(this.no(), 24, JAMA);
        this.setString(this.no(), 25, JAMA);
        this.setString(this.yes(), 28, JAMA);
        this.setString(this.yes(), 29, JAMA);
        this.setString(this.yes(), 30, JAMA);
        this.setString(this.yes(), 31, JAMA);
        this.setString(this.squareTall(), 32, JAMA);
        this.setString(this.squareTall(), 35, JAMA);
        this.setString(this.squareTall(), 33, JAMA);
        this.setString(this.squareTall(), 34, JAMA);
        this.setString(this.yes(), 37, JAMA);
        this.setString(this.yes(), 36, JAMA);
        this.setString(this.no(), 38, JAMA);
        this.setString(this.no(), 39, JAMA);
        this.setString(this.yes(), 40, JAMA);
        this.setString(this.bit32(), 41, JAMA);
        this.setString(this.ram(), 42, JAMA);
        this.setString(this.small("1.2.3"), 0, JBLAS);
        this.setString(this.small("2013"), 1, JBLAS);
        this.setString(this.small("BSD"), 2, JBLAS);
        this.setString(this.no(), 3, JBLAS);
        this.setString(this.yes(), 4, JBLAS);
        this.setString(this.yes(), 5, JBLAS);
        this.setString(this.yes(), 6, JBLAS);
        this.setString(this.yes(), 7, JBLAS);
        this.setString(this.yes() + this.footnote("m", "using native machine code"), 26, JBLAS);
        this.setString(this.yes(), 27, JBLAS);
        this.setString(this.yes(), 8, JBLAS);
        this.setString(this.no(), 9, JBLAS);
        this.setString(this.no(), 10, JBLAS);
        this.setString(this.no(), 11, JBLAS);
        this.setString(this.no(), 13, JBLAS);
        this.setString(this.no(), 12, JBLAS);
        this.setString(this.no(), 14, JBLAS);
        this.setString(this.no(), 15, JBLAS);
        this.setString(this.yes(), 22, JBLAS);
        this.setString(this.yes(), 16, JBLAS);
        this.setString(this.yes(), 17, JBLAS);
        this.setString(this.no(), 18, JBLAS);
        this.setString(this.no(), 19, JBLAS);
        this.setString(this.no(), 20, JBLAS);
        this.setString(this.no(), 21, JBLAS);
        this.setString(this.yes(), 23, JBLAS);
        this.setString(this.no(), 24, JBLAS);
        this.setString(this.no(), 25, JBLAS);
        this.setString(this.yes(), 28, JBLAS);
        this.setString(this.yes(), 29, JBLAS);
        this.setString(this.yes(), 30, JBLAS);
        this.setString(this.yes(), 31, JBLAS);
        this.setString(this.square(), 32, JBLAS);
        this.setString(this.no(), 35, JBLAS);
        this.setString(this.all(), 33, JBLAS);
        this.setString(this.no(), 34, JBLAS);
        this.setString(this.yes() + this.footnote("s", SYMMETRICTEXT), 37, JBLAS);
        this.setString(this.yes(), 36, JBLAS);
        this.setString(this.no(), 38, JBLAS);
        this.setString(this.no(), 39, JBLAS);
        this.setString(this.yes(), 40, JBLAS);
        this.setString(this.bit32(), 41, JBLAS);
        this.setString(this.singleArray(), 42, JBLAS);
        this.setString(this.small("0.6"), 0, JLINALG);
        this.setString(this.small("2009"), 1, JLINALG);
        this.setString(this.small("GPL"), 2, JLINALG);
        this.setString(this.no(), 3, JLINALG);
        this.setString(this.no(), 4, JLINALG);
        this.setString(this.yes(), 5, JLINALG);
        this.setString(this.yes(), 6, JLINALG);
        this.setString(this.yes(), 7, JLINALG);
        this.setString(this.no(), 26, JLINALG);
        this.setString(this.yes(), 27, JLINALG);
        this.setString(this.yes(), 9, JLINALG);
        this.setString(this.no(), 8, JLINALG);
        this.setString(this.no(), 10, JLINALG);
        this.setString(this.no(), 11, JLINALG);
        this.setString(this.no(), 13, JLINALG);
        this.setString(this.no(), 12, JLINALG);
        this.setString(this.no(), 14, JLINALG);
        this.setString(this.no(), 15, JLINALG);
        this.setString(this.yes(), 22, JLINALG);
        this.setString(this.yes(), 16, JLINALG);
        this.setString(this.no(), 17, JLINALG);
        this.setString(this.yes(), 18, JLINALG);
        this.setString(this.yes(), 19, JLINALG);
        this.setString(this.yes(), 20, JLINALG);
        this.setString(this.yes(), 21, JLINALG);
        this.setString(this.yes(), 28, JLINALG);
        this.setString(this.yes(), 29, JLINALG);
        this.setString(this.yes(), 30, JLINALG);
        this.setString(this.yes(), 23, JLINALG);
        this.setString(this.no(), 24, JLINALG);
        this.setString(this.no(), 25, JLINALG);
        this.setString(this.yes(), 31, JLINALG);
        this.setString(this.no() + this.footnote("v", "only for $A \\cdot X = \\mbox{vector}$"), 32, JLINALG);
        this.setString(this.no(), 35, JLINALG);
        this.setString(this.no(), 33, JLINALG);
        this.setString(this.no(), 34, JLINALG);
        this.setString(this.no(), 37, JLINALG);
        this.setString(this.no(), 36, JLINALG);
        this.setString(this.no(), 38, JLINALG);
        this.setString(this.no(), 39, JLINALG);
        this.setString(this.yes(), 40, JLINALG);
        this.setString(this.bit32(), 41, JLINALG);
        this.setString(this.ram(), 42, JLINALG);
        this.setString("", 0, JMATHARRAY);
        this.setString(this.small("2008"), 1, JMATHARRAY);
        this.setString(this.small("BSD"), 2, JMATHARRAY);
        this.setString(this.no(), 3, JMATHARRAY);
        this.setString(this.yes(), 4, JMATHARRAY);
        this.setString(this.yes(), 5, JMATHARRAY);
        this.setString(this.yes(), 6, JMATHARRAY);
        this.setString(this.yes(), 7, JMATHARRAY);
        this.setString(this.no(), 26, JMATHARRAY);
        this.setString(this.no(), 27, JMATHARRAY);
        this.setString(this.yes(), 28, JMATHARRAY);
        this.setString(this.yes(), 29, JMATHARRAY);
        this.setString(this.yes(), 30, JMATHARRAY);
        this.setString(this.yes(), 9, JMATHARRAY);
        this.setString(this.no(), 8, JMATHARRAY);
        this.setString(this.no(), 10, JMATHARRAY);
        this.setString(this.no(), 11, JMATHARRAY);
        this.setString(this.no(), 13, JMATHARRAY);
        this.setString(this.no(), 12, JMATHARRAY);
        this.setString(this.no(), 14, JMATHARRAY);
        this.setString(this.no(), 15, JMATHARRAY);
        this.setString(this.no(), 22, JMATHARRAY);
        this.setString(this.yes(), 16, JMATHARRAY);
        this.setString(this.no(), 17, JMATHARRAY);
        this.setString(this.no(), 18, JMATHARRAY);
        this.setString(this.no(), 19, JMATHARRAY);
        this.setString(this.no(), 20, JMATHARRAY);
        this.setString(this.no(), 21, JMATHARRAY);
        this.setString(this.yes(), 23, JMATHARRAY);
        this.setString(this.no(), 24, JMATHARRAY);
        this.setString(this.no(), 25, JMATHARRAY);
        this.setString(this.yes(), 31, JMATHARRAY);
        this.setString(this.squareTall(), 32, JMATHARRAY);
        this.setString(this.squareTall(), 35, JMATHARRAY);
        this.setString(this.squareTall(), 33, JMATHARRAY);
        this.setString(this.squareTall(), 34, JMATHARRAY);
        this.setString(this.yes(), 37, JMATHARRAY);
        this.setString(this.yes(), 36, JMATHARRAY);
        this.setString(this.no(), 38, JMATHARRAY);
        this.setString(this.no(), 39, JMATHARRAY);
        this.setString(this.yes(), 40, JMATHARRAY);
        this.setString(this.bit32(), 41, JMATHARRAY);
        this.setString(this.ram(), 42, JMATHARRAY);
        this.setString(this.small("0.6"), 0, JMATRICES);
        this.setString(this.small("2004"), 1, JMATRICES);
        this.setString(this.small("LGPL"), 2, JMATRICES);
        this.setString(this.yes(), 3, JMATRICES);
        this.setString(this.yes(), 4, JMATRICES);
        this.setString(this.yes(), 5, JMATRICES);
        this.setString(this.yes(), 6, JMATRICES);
        this.setString(this.yes(), 7, JMATRICES);
        this.setString(this.no(), 26, JMATRICES);
        this.setString(this.no(), 27, JMATRICES);
        this.setString(this.yes(), 9, JMATRICES);
        this.setString(this.no(), 8, JMATRICES);
        this.setString(this.no(), 10, JMATRICES);
        this.setString(this.no(), 11, JMATRICES);
        this.setString(this.no(), 13, JMATRICES);
        this.setString(this.no(), 12, JMATRICES);
        this.setString(this.no(), 14, JMATRICES);
        this.setString(this.no(), 15, JMATRICES);
        this.setString(this.yes(), 22, JMATRICES);
        this.setString(this.yes(), 16, JMATRICES);
        this.setString(this.no(), 17, JMATRICES);
        this.setString(this.yes(), 18, JMATRICES);
        this.setString(this.no(), 19, JMATRICES);
        this.setString(this.no(), 20, JMATRICES);
        this.setString(this.no(), 21, JMATRICES);
        this.setString(this.yes(), 23, JMATRICES);
        this.setString(this.no(), 24, JMATRICES);
        this.setString(this.no(), 25, JMATRICES);
        this.setString(this.yes(), 28, JMATRICES);
        this.setString(this.yes(), 30, JMATRICES);
        this.setString(this.yes(), 29, JMATRICES);
        this.setString(this.yes(), 31, JMATRICES);
        this.setString(this.squareTall(), 32, JMATRICES);
        this.setString(this.square(), 35, JMATRICES);
        this.setString(this.squareTall(), 33, JMATRICES);
        this.setString(this.squareTall(), 34, JMATRICES);
        this.setString(this.yes(), 37, JMATRICES);
        this.setString(this.yes(), 36, JMATRICES);
        this.setString(this.no(), 38, JMATRICES);
        this.setString(this.no(), 39, JMATRICES);
        this.setString(this.yes(), 40, JMATRICES);
        this.setString(this.bit32(), 41, JMATRICES);
        this.setString(this.ram(), 42, JMATRICES);
        this.setString(this.small("1.5.2"), 0, JSCI);
        this.setString(this.small("2009"), 1, JSCI);
        this.setString(this.small("LGPL"), 2, JSCI);
        this.setString(this.yes(), 3, JSCI);
        this.setString(this.yes(), 4, JSCI);
        this.setString(this.yes(), 5, JSCI);
        this.setString(this.yes(), 6, JSCI);
        this.setString(this.yes(), 7, JSCI);
        this.setString(this.no(), 26, JSCI);
        this.setString(this.no(), 27, JSCI);
        this.setString(this.yes(), 9, JSCI);
        this.setString(this.no(), 8, JSCI);
        this.setString(this.no(), 10, JSCI);
        this.setString(this.yes(), 13, JSCI);
        this.setString(this.no(), 11, JSCI);
        this.setString(this.no(), 12, JSCI);
        this.setString(this.no(), 14, JSCI);
        this.setString(this.no(), 15, JSCI);
        this.setString(this.yes(), 22, JSCI);
        this.setString(this.yes(), 16, JSCI);
        this.setString(this.no(), 17, JSCI);
        this.setString(this.no(), 18, JSCI);
        this.setString(this.no(), 19, JSCI);
        this.setString(this.no(), 20, JSCI);
        this.setString(this.no(), 21, JSCI);
        this.setString(this.yes(), 23, JSCI);
        this.setString(this.no(), 24, JSCI);
        this.setString(this.no(), 25, JSCI);
        this.setString(this.yes(), 28, JSCI);
        this.setString(this.yes(), 30, JSCI);
        this.setString(this.yes(), 29, JSCI);
        this.setString(this.no() + this.footnote("v", "only for $A \\cdot X = \\mbox{vector}$"), 32, JSCI);
        this.setString(this.yes(), 31, JSCI);
        this.setString(this.square() + this.footnote(NONSINGULARLETTER, NONSINGULARTEXT), 35, JSCI);
        this.setString(this.square() + this.footnote(NONSINGULARLETTER, NONSINGULARTEXT), 33, JSCI);
        this.setString(this.square(), 34, JSCI);
        this.setString(this.yes() + this.footnote("s", SYMMETRICTEXT) + this.footnote("a", "results not directly accessible"), 37, JSCI);
        this.setString(this.yes(), 36, JSCI);
        this.setString(this.no(), 38, JSCI);
        this.setString(this.no(), 39, JSCI);
        this.setString(this.yes(), 40, JSCI);
        this.setString(this.bit32(), 41, JSCI);
        this.setString(this.ram(), 42, JSCI);
        this.setString(this.small("4.3.1"), 0, JSCIENCE);
        this.setString(this.small("2007"), 1, JSCIENCE);
        this.setString(this.small("BSD"), 2, JSCIENCE);
        this.setString(this.no(), 3, JSCIENCE);
        this.setString(this.yes(), 4, JSCIENCE);
        this.setString(this.yes(), 5, JSCIENCE);
        this.setString(this.yes(), 6, JSCIENCE);
        this.setString(this.yes(), 7, JSCIENCE);
        this.setString(this.yes(), 26, JSCIENCE);
        this.setString(this.no(), 27, JSCIENCE);
        this.setString(this.yes(), 9, JSCIENCE);
        this.setString(this.no(), 10, JSCIENCE);
        this.setString(this.no(), 8, JSCIENCE);
        this.setString(this.yes(), 12, JSCIENCE);
        this.setString(this.no(), 13, JSCIENCE);
        this.setString(this.no(), 15, JSCIENCE);
        this.setString(this.no(), 14, JSCIENCE);
        this.setString(this.yes(), 11, JSCIENCE);
        this.setString(this.yes(), 22, JSCIENCE);
        this.setString(this.yes(), 16, JSCIENCE);
        this.setString(this.no(), 17, JSCIENCE);
        this.setString(this.no(), 18, JSCIENCE);
        this.setString(this.yes(), 19, JSCIENCE);
        this.setString(this.yes(), 20, JSCIENCE);
        this.setString(this.yes(), 21, JSCIENCE);
        this.setString(this.yes(), 23, JSCIENCE);
        this.setString(this.no(), 24, JSCIENCE);
        this.setString(this.no(), 25, JSCIENCE);
        this.setString(this.yes() + this.footnote("f", "flags matrix as transposed"), 28, JSCIENCE);
        this.setString(this.yes(), 29, JSCIENCE);
        this.setString(this.yes(), 30, JSCIENCE);
        this.setString(this.yes(), 31, JSCIENCE);
        this.setString(this.square(), 32, JSCIENCE);
        this.setString(this.no(), 35, JSCIENCE);
        this.setString(this.square() + this.footnote(NONSINGULARLETTER, NONSINGULARTEXT), 33, JSCIENCE);
        this.setString(this.no(), 34, JSCIENCE);
        this.setString(this.no(), 37, JSCIENCE);
        this.setString(this.no(), 36, JSCIENCE);
        this.setString(this.no(), 38, JSCIENCE);
        this.setString(this.no(), 39, JSCIENCE);
        this.setString(this.no(), 40, JSCIENCE);
        this.setString(this.bit32(), 41, JSCIENCE);
        this.setString(this.ram(), 42, JSCIENCE);
        this.setString(this.small("0.4.9"), 0, LA4J);
        this.setString(this.small("2014"), 1, LA4J);
        this.setString(this.small("Apache"), 2, LA4J);
        this.setString(this.no(), 3, LA4J);
        this.setString(this.yes(), 4, LA4J);
        this.setString(this.yes(), 5, LA4J);
        this.setString(this.yes(), 6, LA4J);
        this.setString(this.yes(), 7, LA4J);
        this.setString(this.no(), 26, LA4J);
        this.setString(this.yes(), 27, LA4J);
        this.setString(this.yes(), 28, LA4J);
        this.setString(this.yes(), 30, LA4J);
        this.setString(this.yes(), 29, LA4J);
        this.setString(this.no(), 8, LA4J);
        this.setString(this.yes(), 9, LA4J);
        this.setString(this.no(), 10, LA4J);
        this.setString(this.no(), 11, LA4J);
        this.setString(this.no(), 13, LA4J);
        this.setString(this.no(), 12, LA4J);
        this.setString(this.yes(), 14, LA4J);
        this.setString(this.no(), 15, LA4J);
        this.setString(this.no(), 22, LA4J);
        this.setString(this.yes(), 16, LA4J);
        this.setString(this.no(), 17, LA4J);
        this.setString(this.no(), 18, LA4J);
        this.setString(this.no(), 19, LA4J);
        this.setString(this.no(), 20, LA4J);
        this.setString(this.no(), 21, LA4J);
        this.setString(this.yes(), 23, LA4J);
        this.setString(this.no(), 24, LA4J);
        this.setString(this.no(), 25, LA4J);
        this.setString(this.yes(), 31, LA4J);
        this.setString(this.squareTall(), 32, LA4J);
        this.setString(this.squareTall(), 35, LA4J);
        this.setString(this.square(), 33, LA4J);
        this.setString(this.squareTall(), 34, LA4J);
        this.setString(this.yes(), 37, LA4J);
        this.setString(this.yes(), 36, LA4J);
        this.setString(this.no(), 38, LA4J);
        this.setString(this.no(), 39, LA4J);
        this.setString(this.yes(), 40, LA4J);
        this.setString(this.bit32(), 41, LA4J);
        this.setString(this.ram(), 42, LA4J);
        this.setString(this.small("7.2"), 0, MANTISSA);
        this.setString(this.small("2007"), 1, MANTISSA);
        this.setString(this.small("BSD"), 2, MANTISSA);
        this.setString(this.yes(), 3, MANTISSA);
        this.setString(this.yes(), 4, MANTISSA);
        this.setString(this.yes(), 5, MANTISSA);
        this.setString(this.yes(), 6, MANTISSA);
        this.setString(this.yes(), 7, MANTISSA);
        this.setString(this.no(), 26, MANTISSA);
        this.setString(this.yes(), 27, MANTISSA);
        this.setString(this.yes(), 28, MANTISSA);
        this.setString(this.yes(), 30, MANTISSA);
        this.setString(this.yes(), 29, MANTISSA);
        this.setString(this.yes(), 8, MANTISSA);
        this.setString(this.no(), 9, MANTISSA);
        this.setString(this.no(), 10, MANTISSA);
        this.setString(this.no(), 11, MANTISSA);
        this.setString(this.no(), 13, MANTISSA);
        this.setString(this.no(), 12, MANTISSA);
        this.setString(this.no(), 14, MANTISSA);
        this.setString(this.no(), 15, MANTISSA);
        this.setString(this.no(), 22, MANTISSA);
        this.setString(this.yes(), 16, MANTISSA);
        this.setString(this.no(), 17, MANTISSA);
        this.setString(this.no(), 18, MANTISSA);
        this.setString(this.no(), 19, MANTISSA);
        this.setString(this.no(), 20, MANTISSA);
        this.setString(this.no(), 21, MANTISSA);
        this.setString(this.yes(), 23, MANTISSA);
        this.setString(this.no(), 24, MANTISSA);
        this.setString(this.no(), 25, MANTISSA);
        this.setString(this.yes(), 31, MANTISSA);
        this.setString(this.square(), 32, MANTISSA);
        this.setString(this.no(), 35, MANTISSA);
        this.setString(this.square() + this.footnote("a", "results not directly accessible"), 33, MANTISSA);
        this.setString(this.no(), 34, MANTISSA);
        this.setString(this.no(), 37, MANTISSA);
        this.setString(this.no(), 36, MANTISSA);
        this.setString(this.no(), 38, MANTISSA);
        this.setString(this.no(), 39, MANTISSA);
        this.setString(this.yes(), 40, MANTISSA);
        this.setString(this.bit32(), 41, MANTISSA);
        this.setString(this.singleArray(), 42, MANTISSA);
        this.setString(this.small("1.0.1"), 0, MTJ);
        this.setString(this.small("2013"), 1, MTJ);
        this.setString(this.small("LGPL"), 2, MTJ);
        this.setString(this.no(), 3, MTJ);
        this.setString(this.yes(), 4, MTJ);
        this.setString(this.yes(), 5, MTJ);
        this.setString(this.yes(), 6, MTJ);
        this.setString(this.yes(), 7, MTJ);
        this.setString(this.yes() + this.footnote("m", "using native machine code"), 26, MTJ);
        this.setString(this.yes(), 27, MTJ);
        this.setString(this.yes(), 8, MTJ);
        this.setString(this.no(), 9, MTJ);
        this.setString(this.no(), 10, MTJ);
        this.setString(this.yes(), 14, MTJ);
        this.setString(this.yes(), 15, MTJ);
        this.setString(this.yes(), 12, MTJ);
        this.setString(this.no(), 11, MTJ);
        this.setString(this.no(), 13, MTJ);
        this.setString(this.no(), 22, MTJ);
        this.setString(this.yes(), 16, MTJ);
        this.setString(this.no(), 17, MTJ);
        this.setString(this.no(), 18, MTJ);
        this.setString(this.no(), 19, MTJ);
        this.setString(this.no(), 20, MTJ);
        this.setString(this.no(), 21, MTJ);
        this.setString(this.yes(), 23, MTJ);
        this.setString(this.no(), 24, MTJ);
        this.setString(this.no(), 25, MTJ);
        this.setString(this.yes(), 28, MTJ);
        this.setString(this.yes(), 29, MTJ);
        this.setString(this.yes(), 30, MTJ);
        this.setString(this.yes(), 31, MTJ);
        this.setString(this.squareTall(), 32, MTJ);
        this.setString(this.all(), 35, MTJ);
        this.setString(this.all() + this.footnote("e", ERRORTEXT), 33, MTJ);
        this.setString(this.squareTall(), 34, MTJ);
        this.setString(this.yes() + this.footnote("s", SYMMETRICTEXT), 37, MTJ);
        this.setString(this.yes() + this.footnote("e", ERRORTEXT), 36, MTJ);
        this.setString(this.no(), 38, MTJ);
        this.setString(this.no(), 39, MTJ);
        this.setString(this.yes(), 40, MTJ);
        this.setString(this.bit32(), 41, MTJ);
        this.setString(this.singleArray(), 42, MTJ);
        this.setString(this.small("35.0"), 0, OJALGO);
        this.setString(this.small("2013"), 1, OJALGO);
        this.setString(this.small("MIT"), 2, OJALGO);
        this.setString(this.no(), 3, OJALGO);
        this.setString(this.yes(), 4, OJALGO);
        this.setString(this.yes(), 5, OJALGO);
        this.setString(this.yes(), 6, OJALGO);
        this.setString(this.yes(), 7, OJALGO);
        this.setString(this.yes(), 26, OJALGO);
        this.setString(this.yes(), 27, OJALGO);
        this.setString(this.yes() + this.footnote("f", "flags matrix as transposed"), 28, OJALGO);
        this.setString(this.yes(), 29, OJALGO);
        this.setString(this.yes(), 30, OJALGO);
        this.setString(this.yes(), 8, OJALGO);
        this.setString(this.no(), 9, OJALGO);
        this.setString(this.no(), 10, OJALGO);
        this.setString(this.no(), 15, OJALGO);
        this.setString(this.no(), 14, OJALGO);
        this.setString(this.no(), 13, OJALGO);
        this.setString(this.no(), 12, OJALGO);
        this.setString(this.no(), 11, OJALGO);
        this.setString(this.yes(), 22, OJALGO);
        this.setString(this.yes(), 16, OJALGO);
        this.setString(this.yes(), 17, OJALGO);
        this.setString(this.yes(), 18, OJALGO);
        this.setString(this.no(), 19, OJALGO);
        this.setString(this.no(), 20, OJALGO);
        this.setString(this.no(), 21, OJALGO);
        this.setString(this.yes(), 23, OJALGO);
        this.setString(this.no(), 24, OJALGO);
        this.setString(this.no(), 25, OJALGO);
        this.setString(this.yes(), 31, OJALGO);
        this.setString(this.squareTall(), 32, OJALGO);
        this.setString(this.all(), 35, OJALGO);
        this.setString(this.all(), 33, OJALGO);
        this.setString(this.all(), 34, OJALGO);
        this.setString(this.yes(), 37, OJALGO);
        this.setString(this.yes(), 36, OJALGO);
        this.setString(this.no(), 38, OJALGO);
        this.setString(this.no(), 39, OJALGO);
        this.setString(this.yes(), 40, OJALGO);
        this.setString(this.bit32(), 41, OJALGO);
        this.setString(this.singleArray(), 42, OJALGO);
        this.setString(this.small("0.10.1"), 0, PARALLELCOLT);
        this.setString(this.small("2013"), 1, PARALLELCOLT);
        this.setString(this.small("BSD"), 2, PARALLELCOLT);
        this.setString(this.yes(), 3, PARALLELCOLT);
        this.setString(this.yes(), 4, PARALLELCOLT);
        this.setString(this.yes(), 5, PARALLELCOLT);
        this.setString(this.yes(), 6, PARALLELCOLT);
        this.setString(this.yes(), 7, PARALLELCOLT);
        this.setString(this.yes(), 26, PARALLELCOLT);
        this.setString(this.yes(), 27, PARALLELCOLT);
        this.setString(this.yes() + this.footnote("f", "flags matrix as transposed"), 28, PARALLELCOLT);
        this.setString(this.yes(), 29, PARALLELCOLT);
        this.setString(this.yes(), 30, PARALLELCOLT);
        this.setString(this.yes(), 8, PARALLELCOLT);
        this.setString(this.yes(), 9, PARALLELCOLT);
        this.setString(this.no(), 10, PARALLELCOLT);
        this.setString(this.yes(), 14, PARALLELCOLT);
        this.setString(this.yes(), 12, PARALLELCOLT);
        this.setString(this.yes(), 11, PARALLELCOLT);
        this.setString(this.no(), 13, PARALLELCOLT);
        this.setString(this.no(), 15, PARALLELCOLT);
        this.setString(this.yes(), 22, PARALLELCOLT);
        this.setString(this.yes(), 16, PARALLELCOLT);
        this.setString(this.yes(), 17, PARALLELCOLT);
        this.setString(this.no(), 18, PARALLELCOLT);
        this.setString(this.yes(), 19, PARALLELCOLT);
        this.setString(this.yes(), 20, PARALLELCOLT);
        this.setString(this.no(), 21, PARALLELCOLT);
        this.setString(this.yes(), 23, PARALLELCOLT);
        this.setString(this.yes(), 24, PARALLELCOLT);
        this.setString(this.no(), 25, PARALLELCOLT);
        this.setString(this.yes(), 31, PARALLELCOLT);
        this.setString(this.squareTall(), 32, PARALLELCOLT);
        this.setString(this.all(), 35, PARALLELCOLT);
        this.setString(this.squareTall(), 33, PARALLELCOLT);
        this.setString(this.squareTall(), 34, PARALLELCOLT);
        this.setString(this.yes(), 37, PARALLELCOLT);
        this.setString(this.yes(), 36, PARALLELCOLT);
        this.setString(this.no(), 38, PARALLELCOLT);
        this.setString(this.no(), 39, PARALLELCOLT);
        this.setString(this.yes(), 40, PARALLELCOLT);
        this.setString(this.bit32(), 41, PARALLELCOLT);
        this.setString(this.ram(), 42, PARALLELCOLT);
        this.setString(this.small("1.11"), 0, SST);
        this.setString(this.small("2010"), 1, SST);
        this.setString(this.small("LGPL"), 2, SST);
        this.setString(this.no(), 3, SST);
        this.setString(this.yes() + this.footnote("j", "jar does not work with Java 5"), 4, SST);
        this.setString(this.yes(), 5, SST);
        this.setString(this.yes(), 6, SST);
        this.setString(this.yes(), 7, SST);
        this.setString(this.no(), 26, SST);
        this.setString(this.yes(), 27, SST);
        this.setString(this.yes(), 28, SST);
        this.setString(this.yes(), 29, SST);
        this.setString(this.yes(), 30, SST);
        this.setString(this.yes(), 8, SST);
        this.setString(this.no(), 9, SST);
        this.setString(this.no(), 10, SST);
        this.setString(this.yes(), 11, SST);
        this.setString(this.no(), 12, SST);
        this.setString(this.no(), 13, SST);
        this.setString(this.no(), 15, SST);
        this.setString(this.no(), 14, SST);
        this.setString(this.yes(), 22, SST);
        this.setString(this.yes(), 16, SST);
        this.setString(this.no(), 17, SST);
        this.setString(this.no(), 18, SST);
        this.setString(this.yes(), 19, SST);
        this.setString(this.yes(), 20, SST);
        this.setString(this.yes(), 21, SST);
        this.setString(this.yes(), 23, SST);
        this.setString(this.yes(), 24, SST);
        this.setString(this.yes(), 25, SST);
        this.setString(this.yes(), 31, SST);
        this.setString(this.no(), 32, SST);
        this.setString(this.all(), 35, SST);
        this.setString(this.no(), 33, SST);
        this.setString(this.no(), 34, SST);
        this.setString(this.yes(), 37, SST);
        this.setString(this.no(), 36, SST);
        this.setString(this.no(), 38, SST);
        this.setString(this.no(), 39, SST);
        this.setString(this.no(), 40, SST);
        this.setString(this.bit32(), 41, SST);
        this.setString(this.singleArray(), 42, SST);
        this.setString(this.small("1.5.2"), 0, VECMATH);
        this.setString("2001?", 1, VECMATH);
        this.setString(this.small("other"), 2, VECMATH);
        this.setString(this.no(), 3, VECMATH);
        this.setString(this.yes(), 4, VECMATH);
        this.setString(this.yes(), 5, VECMATH);
        this.setString(this.yes(), 6, VECMATH);
        this.setString(this.yes(), 7, VECMATH);
        this.setString(this.no(), 26, VECMATH);
        this.setString(this.yes(), 27, VECMATH);
        this.setString(this.yes(), 28, VECMATH);
        this.setString(this.no(), 29, VECMATH);
        this.setString(this.yes(), 30, VECMATH);
        this.setString(this.yes(), 9, VECMATH);
        this.setString(this.no(), 8, VECMATH);
        this.setString(this.no(), 10, VECMATH);
        this.setString(this.no(), 11, VECMATH);
        this.setString(this.no(), 12, VECMATH);
        this.setString(this.no(), 15, VECMATH);
        this.setString(this.no(), 14, VECMATH);
        this.setString(this.no(), 13, VECMATH);
        this.setString(this.no(), 22, VECMATH);
        this.setString(this.yes(), 16, VECMATH);
        this.setString(this.no(), 17, VECMATH);
        this.setString(this.no(), 18, VECMATH);
        this.setString(this.no(), 19, VECMATH);
        this.setString(this.no(), 20, VECMATH);
        this.setString(this.no(), 21, VECMATH);
        this.setString(this.yes(), 23, VECMATH);
        this.setString(this.no(), 24, VECMATH);
        this.setString(this.no(), 25, VECMATH);
        this.setString(this.yes(), 31, VECMATH);
        this.setString(this.no(), 32, VECMATH);
        this.setString(this.no() + this.footnote("e", ERRORTEXT), 35, VECMATH);
        this.setString(this.square() + this.footnote(NONSINGULARLETTER, NONSINGULARTEXT), 33, VECMATH);
        this.setString(this.no(), 34, VECMATH);
        this.setString(this.no(), 37, VECMATH);
        this.setString(this.no(), 36, VECMATH);
        this.setString(this.no(), 38, VECMATH);
        this.setString(this.no(), 39, VECMATH);
        this.setString(this.yes(), 40, VECMATH);
        this.setString(this.bit32(), 41, VECMATH);
        this.setString(this.ram(), 42, VECMATH);
    }

    public String yes() {
        switch (this.format) {
            case LATEX: {
                return "\\bf{$+$}";
            }
            case HTMLTABLE: {
                return "<span class=\"text-success fa fa-check-square\"></span>";
            }
            case HTMLLIST: {
                return "yes";
            }
        }
        return "yes";
    }

    public String hdd() {
        switch (this.format) {
            case LATEX: {
                return "~4TB (Disk)";
            }
            case HTMLTABLE: {
                return "~4TB (Disk)";
            }
            case HTMLLIST: {
                return "~4TB (Disk)";
            }
        }
        return "~4TB (Disk)";
    }

    public String ram() {
        switch (this.format) {
            case LATEX: {
                return "~64GB (RAM)";
            }
            case HTMLTABLE: {
                return "~64GB (RAM)";
            }
            case HTMLLIST: {
                return "~64GB (RAM)";
            }
        }
        return "~64GB (RAM)";
    }

    public String singleArray() {
        switch (this.format) {
            case LATEX: {
                return "16GB (Single Array)";
            }
            case HTMLTABLE: {
                return "16GB (Single Array)";
            }
            case HTMLLIST: {
                return "16GB (Single Array)";
            }
        }
        return "16GB (Single Array)";
    }

    public String bit64() {
        switch (this.format) {
            case LATEX: {
                return "2^{63}-1";
            }
            case HTMLTABLE: {
                return "2<sup>63</sup>-1";
            }
            case HTMLLIST: {
                return "2<sup>63</sup>-1";
            }
        }
        return "2^63-1";
    }

    public String bit32() {
        switch (this.format) {
            case LATEX: {
                return "2^{31}-1";
            }
            case HTMLTABLE: {
                return "2<sup>31</sup>-1";
            }
            case HTMLLIST: {
                return "2<sup>31</sup>-1";
            }
        }
        return "2^31-1";
    }

    public String all() {
        switch (this.format) {
            case LATEX: {
                return "\\scalebox{0.6}[1.0]{$\\square$}\\,$\\square$\\,\\scalebox{1.0}[0.6]{$\\square$}";
            }
            case HTMLTABLE: {
                return "<span class=\"fa fa-arrows-v\"></span> <span class=\"fa fa-arrows\"></span> <span class=\"fa fa-arrows-h\"></span>";
            }
        }
        return "all";
    }

    public String squareTall() {
        switch (this.format) {
            case LATEX: {
                return "\\scalebox{0.6}[1.0]{$\\square$}\\,$\\square$";
            }
            case HTMLTABLE: {
                return "<span class=\"fa fa-arrows-v\"></span> <span class=\"fa fa-arrows\"></span>";
            }
        }
        return "square, tall";
    }

    public String square() {
        switch (this.format) {
            case LATEX: {
                return "$\\square$";
            }
            case HTMLTABLE: {
                return "<span class=\"fa fa-arrows\"></span>";
            }
        }
        return "square";
    }

    public String tall() {
        switch (this.format) {
            case LATEX: {
                return "$\\tall$";
            }
            case HTMLTABLE: {
                return "<span class=\"fa fa-arrows-v\"></span>";
            }
        }
        return "tall";
    }

    public String fat() {
        switch (this.format) {
            case LATEX: {
                return "$\\fat$";
            }
            case HTMLTABLE: {
                return "<span class=\"fa fa-arrows-h\"></span>";
            }
        }
        return "fat";
    }

    public String circle() {
        switch (this.format) {
            case LATEX: {
                return "$\\circ$";
            }
        }
        return "square";
    }

    public String no() {
        switch (this.format) {
            case LATEX: {
                return "\\bf{$-$}";
            }
            case HTMLTABLE: {
                return "<span class=\"text-danger fa fa-minus-square\"></span>";
            }
            case HTMLLIST: {
                return "no";
            }
        }
        return "no";
    }

    public String link(String label, String link) {
        switch (this.format) {
            case HTMLTABLE: {
                return "<a href=\"" + link + "\">" + label + "</a>";
            }
            case HTMLLIST: {
                return "<a href=\"" + link + "\">" + label + "</a>";
            }
        }
        return label;
    }

    public String rotate(String text) {
        switch (this.format) {
            case LATEX: {
                return "\\begin{turn}{90}" + text + "\\end{turn}";
            }
        }
        return text;
    }

    public String small(String text) {
        switch (this.format) {
            case LATEX: {
                return "\\small " + text;
            }
            case HTMLLIST: {
                return text;
            }
            case HTMLTABLE: {
                return "<small>" + text + "</small>";
            }
        }
        return text;
    }

    public String footnote(String footnote, String text) {
        switch (this.format) {
            case LATEX: {
                String f = "\\footnotesize{$^\\mathrm{" + footnote + "}$ " + text + "}";
                if (!this.footnotes.contains(f)) {
                    this.footnotes.add(f);
                }
                return "$^{\\mathrm{" + footnote + "}}$";
            }
            case HTMLTABLE: {
                return "";
            }
        }
        String f = footnote + " " + text;
        if (!this.footnotes.contains(f)) {
            this.footnotes.add(f);
        }
        return " (" + text + ")";
    }

    public List<String> getFootnotes() {
        return this.footnotes;
    }

    public static void main(String[] args) throws Exception {
        String s = new MatrixLibraries(MatrixLibrariesFormat.HTMLTABLE).getHtmlTable();
        System.out.println(s);
    }

    public static void printLatex(String[] args) throws Exception {
        MatrixLibraries ml = new MatrixLibraries(MatrixLibrariesFormat.LATEX);
        Matrix m = ml.deleteRows(Calculation.Ret.NEW, ml.getRowCount() - 1L);
        String s = m.exportTo().string().asLatex();
        s = s.replaceAll("table", "sidewaystable");
        s = s.replaceAll("\\\\centering", "");
        s = s.replaceAll("\\\\toprule", "");
        s = s.replaceAll("\\\\begin\\{tabular\\}", "\\\\caption{Overview of matrix libraries in Java}\n\\\\bigskip\n\\\\begin{centering}\n\\\\scalebox{0.8}{%\n\\\\begin{tabular}");
        s = s.replaceAll("latest version", "\\\\toprule\nlatest version");
        s = s.replaceAll("\\\\end\\{sidewaystable\\}", "");
        s = s.replaceAll("\\\\end\\{tabular\\}", "\\\\end{tabular}}\n\\\\end{centering}");
        s = s.replaceAll("version &", "\\\\toprule\nversion &");
        s = s.replaceAll("Java 1.4 &", "\\\\midrule\nJava 1.4 &");
        s = s.replaceAll("multithreaded &", "\\\\midrule\nmultithreaded &");
        s = s.replaceAll("dense SA", "\\\\midrule\ndense SA");
        s = s.replaceAll("sparse DOK", "\\\\midrule\nsparse DOK");
        s = s.replaceAll("double &", "\\\\midrule\ndouble &");
        s = s.replaceAll("2D &", "\\\\midrule\n2D &");
        s = s.replaceAll("transpose &", "\\\\midrule\ntranspose &");
        s = s.replaceAll("inverse &", "\\\\midrule\ninverse &");
        s = s + "\\medskip\n";
        s = s + "\\begin{tabular}{p{0.25\\textwidth}p{0.25\\textwidth}p{0.25\\textwidth}p{0.25\\textwidth}}\n";
        s = s + "\\renewcommand{\\tabcolsep}{30pt}";
        List<String> fn = ml.getFootnotes();
        Collections.sort(fn);
        for (int i = 0; i < fn.size(); ++i) {
            String f = fn.get(i);
            s = s + f;
            s = i % 4 == 3 ? s + "\\\\\n" : s + " & ";
        }
        s = s + "\\end{tabular}\n";
        s = s + "\\end{sidewaystable}";
        System.out.println(s);
    }

    public String getHtmlTable() {
        StringBuilder s = new StringBuilder();
        s.append("<div class=\"table-responsive\" style=\"overflow-x: scroll;\">\n");
        s.append("<table class=\"text-center table table-striped table-hover table-condensed\">\n");
        s.append("<tbody>\n");
        s.append("<tr>\n");
        s.append("<th>\n");
        s.append("</th>\n");
        int c = 0;
        while ((long)c < this.getColumnCount()) {
            String label = this.getColumnLabel(c);
            s.append("<th class=\"text-center\">" + label + "</th>\n");
            ++c;
        }
        s.append("</tr>\n");
        int r = 0;
        while ((long)r < this.getRowCount()) {
            s.append("<tr>\n");
            String feature = this.getRowLabel(r);
            s.append("<th>" + feature + "</th>\n");
            int c2 = 0;
            while ((long)c2 < this.getColumnCount()) {
                String result = this.getString(r, c2);
                s.append("<td>" + result + "</td>\n");
                ++c2;
            }
            s.append("</tr>\n");
            ++r;
        }
        s.append("</tbody>\n");
        s.append("</table>\n");
        s.append("</div>\n");
        return s.toString();
    }

    public String getHtmlList() {
        StringBuilder s = new StringBuilder();
        int c = 0;
        while ((long)c < this.getColumnCount()) {
            String label = this.getColumnLabel(c);
            s.append("<h2>");
            s.append(label);
            s.append("</h2>\n");
            s.append("<p>These are the features of the <strong>" + label + "</strong> library:</p>");
            s.append("<ul>\n");
            int r = 0;
            while ((long)r < this.getRowCount()) {
                String feature = this.getRowLabel(r);
                String result = this.getString(r, c);
                if (!"no".equals(result)) {
                    if ("yes".equals(result)) {
                        s.append("<li>" + label + " ");
                        s.append(feature);
                        s.append("</li>\n");
                    } else if (!"no".equals(result)) {
                        s.append("<li>" + label + " ");
                        s.append(feature + ": ");
                        s.append(this.getString(r, c));
                        s.append("</li>\n");
                    }
                }
                ++r;
            }
            s.append("</ul>\n\n");
            ++c;
        }
        return s.toString();
    }

    public static enum MatrixLibrariesFormat {
        DEFAULT,
        LATEX,
        HTMLTABLE,
        HTMLLIST;

    }

    public static enum MatrixLibrary {
        Colt,
        CommonsMath,
        EJML,
        JAMA,
        jblas,
        JlinAlg,
        JMathArray,
        JMatrices,
        Jsci,
        Jscience,
        la4j,
        Mantissa,
        MTJ,
        ojAlgo,
        ParallelColt,
        SST,
        UJMP,
        VecMath;

    }
}

