/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.concurrent.UJMPThreadPoolExecutor;

public abstract class PFor {
    private final Object[] objects;

    public PFor(int threads, int first, int last) {
        this(threads, first, last, new Object[0]);
    }

    public PFor(int threads, int first, int last, Object ... objects) {
        this.objects = objects;
        if (threads < 2) {
            for (int i = first; i <= last; ++i) {
                this.step(i);
            }
        } else {
            ThreadPoolExecutor es = UJMPThreadPoolExecutor.getInstance(threads);
            Future[] list = new Future[threads];
            double stepsize = (double)(last + 1 - first) / (double)threads;
            for (int i = 0; i < threads; ++i) {
                int starti = (int)Math.ceil((double)first + (double)i * stepsize);
                int endi = (int)Math.ceil((double)first + (double)(i + 1) * stepsize);
                list[i] = es.submit(new StepCallable(starti, endi));
            }
            for (Future f : list) {
                try {
                    f.get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public PFor(int first, int last) {
        this(first, last, new Object[0]);
    }

    public PFor(int first, int last, Object ... objects) {
        this(UJMPSettings.getInstance().getNumberOfThreads(), first, last, objects);
    }

    public abstract void step(int var1);

    public final Object getObject(int i) {
        return this.objects[i];
    }

    class StepCallable
    implements Callable<Object> {
        private final int first;
        private final int last;

        public StepCallable(int first, int last) {
            this.first = first;
            this.last = last;
        }

        @Override
        public final Void call() throws Exception {
            for (int i = this.first; i < this.last; ++i) {
                PFor.this.step(i);
            }
            return null;
        }
    }
}

