/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public abstract class SerializationUtil {
    public static void serialize(Object obj, OutputStream outputStream) throws IOException {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(outputStream);
            out.writeObject(obj);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static Object deserialize(InputStream inputStream) throws ClassNotFoundException, IOException {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(inputStream);
            Object object = in.readObject();
            return object;
        }
        catch (ClassNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] serialize(Serializable o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SerializationUtil.serialize(o, bos);
        return bos.toByteArray();
    }

    public static Object deserialize(byte[] data) throws ClassNotFoundException, IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        Object o = SerializationUtil.deserialize(bis);
        return o;
    }

    public static long sizeOf(Serializable o) throws IOException {
        return SerializationUtil.serialize(o).length;
    }

    public static Object load(String filename) throws ClassNotFoundException, IOException {
        return SerializationUtil.load(new File(filename));
    }

    public static Object load(File file) throws ClassNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        Object o = SerializationUtil.deserialize(bis);
        bis.close();
        fis.close();
        return o;
    }

    public static Object loadCompressed(String filename) throws ClassNotFoundException, IOException {
        return SerializationUtil.loadCompressed(new File(filename));
    }

    public static Object loadCompressed(File file) throws ClassNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        GZIPInputStream bis = new GZIPInputStream(fis);
        Object o = SerializationUtil.deserialize(bis);
        bis.close();
        fis.close();
        return o;
    }

    public static void save(String filename, Object o) throws IOException {
        SerializationUtil.save(new File(filename), o);
    }

    public static void save(File file, Object o) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        SerializationUtil.serialize(o, bos);
        bos.close();
        fos.close();
    }

    public static void saveCompressed(String filename, Object o) throws IOException {
        SerializationUtil.saveCompressed(new File(filename), o);
    }

    public static void saveCompressed(File file, Object o) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        GZIPOutputStream bos = new GZIPOutputStream(fos);
        SerializationUtil.serialize(o, bos);
        bos.close();
        fos.close();
    }
}

