/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.ujmp.core.util.MathUtil;

public class LongArrayList {
    private static final int DEFAULT_CAPACITY = 10;
    private static final long[] EMPTY_ELEMENTDATA = new long[0];
    private transient long[] elementData;
    private int modCount = 0;
    private int size;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public LongArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new long[initialCapacity];
    }

    public LongArrayList() {
        this.elementData = EMPTY_ELEMENTDATA;
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.size < this.elementData.length) {
            this.elementData = Arrays.copyOf(this.elementData, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int minExpand;
        int n = minExpand = this.elementData != EMPTY_ELEMENTDATA ? 0 : 10;
        if (minCapacity > minExpand) {
            this.ensureExplicitCapacity(minCapacity);
        }
    }

    private void ensureCapacityInternal(int minCapacity) {
        if (this.elementData == EMPTY_ELEMENTDATA) {
            minCapacity = Math.max(10, minCapacity);
        }
        this.ensureExplicitCapacity(minCapacity);
    }

    private void ensureExplicitCapacity(int minCapacity) {
        ++this.modCount;
        if (minCapacity - this.elementData.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.elementData.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = LongArrayList.hugeCapacity(minCapacity);
        }
        this.elementData = Arrays.copyOf(this.elementData, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public long size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(long o) {
        return this.indexOf(o) >= 0;
    }

    public int indexOf(long o) {
        for (int i = 0; i < this.size; ++i) {
            if (o != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long o) {
        for (int i = MathUtil.longToInt(this.size) - 1; i >= 0; --i) {
            if (o != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public long[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    public long get(int index) {
        return this.elementData[index];
    }

    public long set(int index, long element) {
        long oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    public boolean add(long e) {
        this.ensureCapacityInternal(this.size + 1);
        this.elementData[this.size++] = e;
        return true;
    }

    public void add(int index, long element) {
        this.ensureCapacityInternal(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element;
        ++this.size;
    }

    public long remove(int index) {
        this.rangeCheck(index);
        ++this.modCount;
        long oldValue = this.elementData[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        return oldValue;
    }

    public boolean remove(long o) {
        for (int index = 0; index < this.size; ++index) {
            if (o != this.elementData[index]) continue;
            this.fastRemove(index);
            return true;
        }
        return false;
    }

    private void fastRemove(int index) {
        ++this.modCount;
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        int newSize;
        ++this.modCount;
        int numMoved = this.size - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
        this.size = newSize = this.size - (toIndex - fromIndex);
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    public ListIterator<Long> listIterator(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public ListIterator<Long> listIterator() {
        return new ListItr(0);
    }

    public Iterator<Long> iterator() {
        return new Itr();
    }

    private class ListItr
    extends Itr
    implements ListIterator<Long> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public Long previous() {
            this.checkForComodification();
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            long[] elementData = LongArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void set(Long e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                LongArrayList.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(Long e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                LongArrayList.this.add(i, e);
                this.cursor = i + 1;
                this.lastRet = -1;
                this.expectedModCount = LongArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator<Long> {
        int cursor;
        int lastRet = -1;
        int expectedModCount = LongArrayList.access$100(LongArrayList.this);

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != LongArrayList.this.size;
        }

        @Override
        public Long next() {
            this.checkForComodification();
            int i = this.cursor;
            if (i >= LongArrayList.this.size) {
                throw new NoSuchElementException();
            }
            long[] elementData = LongArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                LongArrayList.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = LongArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (LongArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

