/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.StringUtil;

public abstract class CommandLineUtil {
    public static final void parse(MapMatrix<String, Object> matrix, String ... args) {
        for (String s : args) {
            if (s == null) continue;
            if (s.startsWith("--")) {
                CommandLineUtil.addArgument(matrix, s.replaceFirst("--", ""));
                continue;
            }
            if (s.startsWith("-")) {
                CommandLineUtil.addArgument(matrix, s.replaceFirst("-", ""));
                continue;
            }
            matrix.put("name", s);
        }
    }

    private static void addArgument(MapMatrix<String, Object> matrix, String s) {
        if (s.contains("=")) {
            String[] keyValue = s.split("=");
            String key = keyValue[0];
            String value = keyValue[1];
            CommandLineUtil.addKeyValue(matrix, key, value);
        } else {
            CommandLineUtil.addKeyValue(matrix, s, true);
        }
    }

    private static void addKeyValue(MapMatrix<String, Object> matrix, String key, Object value) {
        for (String k : matrix.keySet()) {
            if (!k.equalsIgnoreCase(key)) continue;
            matrix.put(k, value);
            break;
        }
    }

    public static final void printOptions(MapMatrix<String, Object> config) {
        for (String s : config.keySet()) {
            System.out.println(StringUtil.padLeft("--" + s, 20) + " (default: " + config.get(s) + ")");
        }
    }
}

