/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.timeseries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.ujmp.core.Matrix;
import org.ujmp.core.collections.composite.SortedListSet;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;

public class TimeSeriesMatrix
extends AbstractDenseDoubleMatrix2D {
    private static final long serialVersionUID = 4326920011599023858L;
    private Interpolation defaultInterpolation = Interpolation.NONE;
    private final Map<Integer, Interpolation> seriesInterpolations = new HashMap<Integer, Interpolation>();
    private final List<SortedMap<Long, Double>> series = new ArrayList<SortedMap<Long, Double>>();
    private final SortedListSet<Long> timestampsListSet = new SortedListSet();

    public TimeSeriesMatrix() {
        super(1L, 1L);
    }

    public void addEvent(long timestamp, Matrix value) {
        if (value.getRowCount() != 1L) {
            throw new RuntimeException("matrix cannot have more than one row");
        }
        int id = 0;
        while ((long)id < value.getColumnCount()) {
            this.addEvent(timestamp, id + 1, value.getAsDouble(0L, id));
            ++id;
        }
    }

    public Interpolation getInterpolation(int seriesId) {
        Interpolation i = this.seriesInterpolations.get(seriesId);
        if (i == null) {
            return this.defaultInterpolation;
        }
        return i;
    }

    public Interpolation getDefaultInterpolation() {
        return this.defaultInterpolation;
    }

    public void setDefaultInterpolation(Interpolation defaultInterpolation) {
        this.defaultInterpolation = defaultInterpolation;
    }

    public void addEvents(Matrix events) {
        int seriesCount = this.getSeriesCount();
        int r = 0;
        while ((long)r < events.getRowCount()) {
            long timestamp = events.getAsLong(r, 0L);
            int c = 1;
            while ((long)c < events.getColumnCount()) {
                double value = events.getAsDouble(r, c);
                this.addEvent(timestamp, seriesCount + c - 1, value);
                ++c;
            }
            ++r;
        }
    }

    public void addEvent(long timestamp, int column, double value) {
        int seriesId = column - 1;
        while (this.series.size() <= seriesId) {
            this.series.add(new TreeMap());
        }
        SortedMap<Long, Double> map = this.series.get(seriesId);
        map.put(timestamp, value);
        this.timestampsListSet.add(timestamp);
    }

    public int getEventCount() {
        return this.timestampsListSet.size();
    }

    public int getSeriesCount() {
        return this.series.size();
    }

    public List<Long> getTimestamps() {
        return this.timestampsListSet;
    }

    @Override
    public long[] getSize() {
        this.size[0] = this.getEventCount();
        this.size[1] = this.getSeriesCount() + 1;
        return this.size;
    }

    @Override
    public long getRowCount() {
        return this.getEventCount();
    }

    @Override
    public long getColumnCount() {
        return this.getSeriesCount() + 1;
    }

    @Override
    public double getDouble(long row, long column) {
        return this.getDouble((int)row, (int)column);
    }

    @Override
    public double getDouble(int row, int column) {
        if (row < 0 || (long)column >= this.getColumnCount() || (long)row >= this.getRowCount()) {
            return Double.NaN;
        }
        int seriesId = column - 1;
        long timestamp = this.timestampsListSet.get(row);
        if (column == 0) {
            return timestamp;
        }
        SortedMap<Long, Double> map = this.series.get(seriesId);
        switch (this.getInterpolation(seriesId)) {
            case NONE: {
                Double v = (Double)map.get(timestamp);
                if (v == null) {
                    return Double.NaN;
                }
                return v;
            }
            case STEPS: {
                long t;
                Iterator<Long> it = map.keySet().iterator();
                double value = 0.0;
                while (it.hasNext() && (t = it.next().longValue()) <= timestamp) {
                    value = (Double)map.get(t);
                }
                return value;
            }
        }
        throw new RuntimeException("Interpolation method not (yet) supported: " + (Object)((Object)this.getInterpolation(seriesId)));
    }

    @Override
    public void setDouble(double value, long row, long column) {
        throw new RuntimeException("please use addEvent() for making changes");
    }

    @Override
    public void setDouble(double value, int row, int column) {
        throw new RuntimeException("please use addEvent() for making changes");
    }

    public void setInterpolation(int column, Interpolation interpolation) {
        int seriesId = column - 1;
        this.seriesInterpolations.put(seriesId, interpolation);
    }

    public long getRowForTime(long time) {
        long rows = this.getRowCount();
        long r = 0L;
        while (r < rows) {
            long t;
            if ((t = this.getAsLong(r++, 0L)) != time) continue;
            return r;
        }
        return -1L;
    }

    public double getAsDoubleForTime(long time, long column) {
        long row = this.getRowForTime(time);
        if (row < 0L || column >= this.getColumnCount()) {
            return Double.NaN;
        }
        return this.getAsDouble(row, column);
    }

    public long getTimestamp(long row) {
        if (row < 0L | row >= (long)this.timestampsListSet.size()) {
            return 0L;
        }
        return this.timestampsListSet.get((int)row);
    }

    public long getMinTimestamp() {
        if (this.timestampsListSet.isEmpty()) {
            return 0L;
        }
        return this.timestampsListSet.first();
    }

    public long getMaxTimestamp() {
        if (this.timestampsListSet.isEmpty()) {
            return 0L;
        }
        return this.timestampsListSet.last();
    }

    public static enum Interpolation {
        NONE,
        STEPS,
        LINEAR;

    }
}

