/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.stringmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.stringmatrix.StringMatrix;
import org.ujmp.core.stringmatrix.calculation.StringCalculation;
import org.ujmp.core.stringmatrix.impl.StringCalculationMatrix;

public abstract class AbstractStringCalculation
extends AbstractCalculation
implements StringCalculation {
    private static final long serialVersionUID = 6467659591327635319L;

    public AbstractStringCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractStringCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    @Override
    public final StringMatrix calcLink() {
        return new StringCalculationMatrix(this);
    }

    @Override
    public final Matrix calcOrig() {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new RuntimeException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsString(this.getString(c), c);
        }
        this.getSource().fireValueChanged();
        return this.getSource();
    }

    @Override
    public final StringMatrix calcNew() {
        StringMatrix result = (StringMatrix)Matrix.Factory.zeros(ValueType.STRING, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsString(this.getString(c), c);
        }
        if (this.getMetaData() != null) {
            result.setMetaData((MapMatrix<String, Object>)this.getMetaData().clone());
        }
        return result;
    }

    @Override
    public void setString(String value, long ... coordinates) {
    }

    @Override
    public final ValueType getValueType() {
        return ValueType.STRING;
    }
}

