/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ujmp.core.Coordinates;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.objectmatrix.impl.DefaultSparseObjectMatrix;
import org.ujmp.core.objectmatrix.stub.AbstractSparseObjectMatrix2D;
import org.ujmp.core.util.MathUtil;

public class DefaultSparseRowObjectMatrix2D
extends AbstractSparseObjectMatrix2D
implements Wrapper<Map<Long, Matrix>> {
    private static final long serialVersionUID = -5291604525500706427L;
    private Map<Long, Matrix> rows = new HashMap<Long, Matrix>();

    public DefaultSparseRowObjectMatrix2D(long rows, long columns) {
        super(rows, columns);
        this.setSize(rows, columns);
    }

    public DefaultSparseRowObjectMatrix2D(Matrix m) {
        super(m.getRowCount(), m.getColumnCount());
        this.setSize(m.getSize());
        for (long[] c : m.availableCoordinates()) {
            this.setObject(m.getAsObject(c), c);
        }
        if (m.getMetaData() != null) {
            this.setMetaData((MapMatrix<String, Object>)m.getMetaData().clone());
        }
    }

    @Override
    public final void clear() {
        this.rows.clear();
    }

    @Override
    public Object getObject(long row, long column) {
        Matrix m = this.rows.get(row);
        return m == null ? null : m.getAsObject(0L, column);
    }

    @Override
    public Object getObject(int row, int column) {
        return this.getObject((long)row, (long)column);
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        ArrayList<long[]> coordinates = new ArrayList<long[]>();
        for (Long r : this.rows.keySet()) {
            Matrix m = this.rows.get(r);
            for (long[] c : m.availableCoordinates()) {
                coordinates.add(Coordinates.plus(c, new long[]{r, 0L}));
            }
        }
        return coordinates;
    }

    @Override
    public boolean containsCoordinates(long ... coordinates) {
        if (Coordinates.isSmallerThan(coordinates, this.size)) {
            return this.getObject(coordinates) != null;
        }
        return false;
    }

    @Override
    public double getAsDouble(long ... coordinates) {
        return MathUtil.getDouble(this.getObject(coordinates));
    }

    @Override
    public void setAsDouble(double value, long ... coordinates) {
        this.setObject((Object)value, coordinates);
    }

    @Override
    public void setObject(Object o, long row, long column) {
        Matrix m = this.rows.get(row);
        if (m == null) {
            m = new DefaultSparseObjectMatrix(1L, this.getColumnCount());
            this.rows.put(row, m);
        }
        m.setAsObject(o, 0L, column);
    }

    @Override
    public void setObject(Object o, int row, int column) {
        this.setObject(o, (long)row, (long)column);
    }

    @Override
    public void setSize(long ... size) {
        if (this.size[1] != size[1]) {
            for (Matrix m : this.rows.values()) {
                m.setSize(1L, size[1]);
            }
        }
        this.size = size;
    }

    public Matrix getRow(long row) {
        return this.rows.get(row);
    }

    @Override
    public Matrix max(Calculation.Ret returnType, int dimension) {
        if (returnType == Calculation.Ret.NEW) {
            if (dimension == 0) {
                DenseMatrix ret = Matrix.Factory.zeros(1L, this.getColumnCount());
                for (long[] c : this.availableCoordinates()) {
                    double v = this.getAsDouble(c);
                    long[] lArray = new long[]{0L, c[1]};
                    if (!(v > ret.getAsDouble(lArray))) continue;
                    ret.setAsDouble(v, 0L, c[1]);
                }
                return ret;
            }
            if (dimension == 1) {
                DenseMatrix ret = Matrix.Factory.zeros(this.getRowCount(), 1L);
                for (long[] c : this.availableCoordinates()) {
                    double v = this.getAsDouble(c);
                    long[] lArray = new long[]{c[0], 0L};
                    if (!(v > ret.getAsDouble(lArray))) continue;
                    ret.setAsDouble(v, c[0], 0L);
                }
                return ret;
            }
        }
        throw new RuntimeException("not supported");
    }

    @Override
    public Matrix selectRows(Calculation.Ret returnType, long ... rows) {
        if (returnType == Calculation.Ret.LINK && rows.length == 1) {
            return this.getRow(rows[0]);
        }
        return super.selectRows(returnType, rows);
    }

    @Override
    public Map<Long, Matrix> getWrappedObject() {
        return this.rows;
    }

    public void setWrappedObject(Map<Long, Matrix> object) {
        this.rows = object;
    }
}

