/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.longmatrix.LongMatrix2D;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;
import org.ujmp.core.objectmatrix.impl.DefaultSparseObjectMatrix;
import org.ujmp.core.util.Sortable;

public class Sortrows
extends AbstractObjectCalculation {
    private static final long serialVersionUID = -6935375114060680121L;
    private LongMatrix2D index = null;
    private long column = 0L;
    private boolean reverse = false;

    public Sortrows(Matrix m, long column, boolean reverse) {
        super(m);
        this.column = Math.abs(column);
        this.reverse = reverse;
        this.createSortIndex();
    }

    @Override
    public Object getObject(long ... coordinates) {
        return this.getSource().getAsObject(this.index.getLong(coordinates[0], 0L), coordinates[1]);
    }

    private void createSortIndex() {
        Matrix m = this.getSource();
        long rowCount = m.getRowCount();
        ArrayList<Sortable<Object, Long>> rows = new ArrayList<Sortable<Object, Long>>();
        switch (m.getValueType()) {
            case BIGDECIMAL: {
                Iterator c;
                long r;
                for (r = 0L; r < rowCount; ++r) {
                    c = m.getAsBigDecimal(r, this.column);
                    rows.add(new Sortable<Object, Long>(c, r, true));
                }
                break;
            }
            case BIGINTEGER: {
                Iterator c;
                long r;
                for (r = 0L; r < rowCount; ++r) {
                    c = m.getAsBigInteger(r, this.column);
                    rows.add(new Sortable<Object, Long>(c, r, true));
                }
                break;
            }
            case DOUBLE: {
                Iterator c;
                long r;
                for (r = 0L; r < rowCount; ++r) {
                    c = m.getAsDouble(r, this.column);
                    rows.add(new Sortable<Object, Long>(c, r, true));
                }
                break;
            }
            case INT: {
                Iterator c;
                long r;
                for (r = 0L; r < rowCount; ++r) {
                    c = m.getAsInt(r, this.column);
                    rows.add(new Sortable<Object, Long>(c, r, true));
                }
                break;
            }
            case FLOAT: {
                Iterator c;
                long r;
                for (r = 0L; r < rowCount; ++r) {
                    c = Float.valueOf(m.getAsFloat(r, this.column));
                    rows.add(new Sortable<Object, Long>(c, r, true));
                }
                break;
            }
            case CHAR: {
                Iterator c;
                long r;
                for (r = 0L; r < rowCount; ++r) {
                    c = Character.valueOf(m.getAsChar(r, this.column));
                    rows.add(new Sortable<Object, Long>(c, r, true));
                }
                break;
            }
            case BYTE: {
                Iterator c;
                long r;
                for (r = 0L; r < rowCount; ++r) {
                    c = m.getAsByte(r, this.column);
                    rows.add(new Sortable<Object, Long>(c, r, true));
                }
                break;
            }
            case BOOLEAN: {
                Iterator c;
                long r;
                for (r = 0L; r < rowCount; ++r) {
                    c = m.getAsBoolean(r, this.column);
                    rows.add(new Sortable<Object, Long>(c, r, true));
                }
                break;
            }
            case LONG: {
                Iterator c;
                long r;
                for (r = 0L; r < rowCount; ++r) {
                    c = m.getAsLong(r, this.column);
                    rows.add(new Sortable<Object, Long>(c, r, true));
                }
                break;
            }
            case SHORT: {
                Iterator c;
                long r;
                for (r = 0L; r < rowCount; ++r) {
                    c = m.getAsShort(r, this.column);
                    rows.add(new Sortable<Object, Long>(c, r, true));
                }
                break;
            }
            default: {
                Iterator c;
                long r;
                for (r = 0L; r < rowCount; ++r) {
                    c = m.getAsString(r, this.column);
                    rows.add(new Sortable<Object, Long>(c, r, true));
                }
            }
        }
        Collections.sort(rows);
        if (this.reverse) {
            Collections.reverse(rows);
        }
        LongMatrix2D indexMatrix = (LongMatrix2D)LongMatrix2D.Factory.zeros((long)rows.size(), 1L);
        MapMatrix<String, Object> annotation = m.getMetaData();
        if (annotation != null) {
            annotation = new DefaultMapMatrix<String, Object>(new TreeMap());
            for (String key : m.getMetaData().keySet()) {
                Object o = m.getMetaData(key);
                if (o instanceof Matrix) {
                    annotation.put(key, ((Matrix)o).clone());
                    continue;
                }
                annotation.put(key, o);
            }
            this.setMetaData(annotation);
        }
        for (int r = 0; r < rows.size(); ++r) {
            indexMatrix.setLong((long)((Long)((Sortable)rows.get(r)).getObject()), r, 0);
            if (annotation == null) continue;
            Object o = m.getDimensionMetaData(1, (Long)((Sortable)rows.get(r)).getObject(), 0L);
            Matrix ma = (Matrix)annotation.get("DimensionMetaData1");
            if (ma == null) {
                ma = new DefaultSparseObjectMatrix(1L, 1L);
                annotation.put("DimensionMetaData1", ma);
            }
            if (!Coordinates.isSmallerThan(new long[]{r, 0L}, ma.getSize())) {
                long[] newSize = Coordinates.max(ma.getSize(), Coordinates.plus(new long[]{r, 0L}, 1L));
                ma.setSize(newSize);
            }
            ma.setAsObject(o, r, 0L);
        }
        this.index = indexMatrix;
    }

    public LongMatrix2D getIndex() {
        return this.index;
    }
}

