/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import java.util.ArrayList;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;
import org.ujmp.core.util.MathUtil;

public class Bootstrap
extends AbstractObjectCalculation {
    private static final long serialVersionUID = -5084329826465538416L;
    private int count = 0;
    private Matrix selection = null;

    public Bootstrap(Matrix m) {
        this(m, (int)m.getRowCount());
    }

    public Bootstrap(Matrix m, int count) {
        super(m);
        this.count = count;
    }

    @Override
    public Object getObject(long ... coordinates) {
        if (this.selection == null) {
            ArrayList<Integer> rows = new ArrayList<Integer>();
            for (int i = 0; i < this.count; ++i) {
                int s = MathUtil.nextInteger(0, (int)this.getSource().getRowCount());
                rows.add(s);
            }
            this.selection = this.getSource().selectRows(Calculation.Ret.LINK, rows);
        }
        return this.selection.getAsObject(coordinates);
    }

    @Override
    public long[] getSize() {
        return new long[]{this.count, this.getSource().getColumnCount()};
    }
}

