/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.listmatrix;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.ujmp.core.genericmatrix.stub.AbstractDenseGenericMatrix2D;
import org.ujmp.core.listmatrix.ListMatrix;
import org.ujmp.core.util.MathUtil;

public abstract class AbstractListMatrix<E>
extends AbstractDenseGenericMatrix2D<E>
implements ListMatrix<E> {
    private static final long serialVersionUID = -6776628601679785451L;

    public AbstractListMatrix() {
        super(0L, 1L);
    }

    @Override
    public abstract E get(int var1);

    @Override
    public final boolean add(E t) {
        boolean ret = this.addToList(t);
        this.fireValueChanged();
        return ret;
    }

    protected abstract boolean addToList(E var1);

    protected abstract void addToList(int var1, E var2);

    @Override
    public final E getObject(long row, long column) {
        return this.get(MathUtil.longToInt(row));
    }

    @Override
    public final void setObject(E value, long row, long column) {
        this.set(MathUtil.longToInt(row), value);
    }

    @Override
    public void add(int index, E element) {
        this.addToList(index, element);
        this.fireValueChanged();
    }

    @Override
    public final E remove(int index) {
        E e = this.removeFromList(index);
        this.fireValueChanged();
        return e;
    }

    protected abstract E removeFromList(int var1);

    @Override
    public final boolean remove(Object o) {
        boolean ret = this.removeFromList(o);
        this.fireValueChanged();
        return ret;
    }

    protected abstract boolean removeFromList(Object var1);

    @Override
    public final E set(int index, E element) {
        E ret = this.setToList(index, element);
        this.fireValueChanged();
        return ret;
    }

    protected abstract E setToList(int var1, E var2);

    @Override
    public final void clear() {
        this.clearList();
        this.fireValueChanged();
    }

    protected abstract void clearList();

    @Override
    public abstract int size();

    @Override
    public final long[] getSize() {
        this.size[0] = this.size();
        return this.size;
    }

    @Override
    public final boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!this.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int indexOf(Object o) {
        ListIterator<E> it = this.listIterator();
        if (o == null) {
            while (it.hasNext()) {
                if (it.next() != null) continue;
                return it.previousIndex();
            }
        } else {
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                return it.previousIndex();
            }
        }
        return -1;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final int lastIndexOf(Object o) {
        ListIterator<E> it = this.listIterator(this.size());
        if (o == null) {
            while (it.hasPrevious()) {
                if (it.previous() != null) continue;
                return it.nextIndex();
            }
        } else {
            while (it.hasPrevious()) {
                if (!o.equals(it.previous())) continue;
                return it.nextIndex();
            }
        }
        return -1;
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        boolean ret = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int current = -1;

            @Override
            public boolean hasNext() {
                return this.current < AbstractListMatrix.this.size() - 1;
            }

            @Override
            public E next() {
                ++this.current;
                return AbstractListMatrix.this.get(this.current);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final Object[] toArray() {
        Object[] objects = new Object[this.size()];
        for (int i = this.size() - 1; i != -1; --i) {
            objects[i] = this.get(i);
        }
        return objects;
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        Object[] objects = (Object[])Array.newInstance(a.getClass(), this.size());
        for (int i = this.size() - 1; i != -1; --i) {
            objects[i] = this.get(i);
        }
        return objects;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean ret = false;
        for (E o : c) {
            if (!this.addToList(o)) continue;
            ret = true;
        }
        if (ret) {
            this.fireValueChanged();
        }
        return ret;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        boolean ret = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            ret = true;
        }
        if (ret) {
            this.fireValueChanged();
        }
        return ret;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListIterator<E>(){
            int current = -1;

            @Override
            public boolean hasNext() {
                return this.current < AbstractListMatrix.this.size() - 1;
            }

            @Override
            public E next() {
                ++this.current;
                return AbstractListMatrix.this.get(this.current);
            }

            @Override
            public boolean hasPrevious() {
                return this.current > 0;
            }

            @Override
            public E previous() {
                Object e = AbstractListMatrix.this.get(this.current);
                --this.current;
                return e;
            }

            @Override
            public int nextIndex() {
                return this.current + 1;
            }

            @Override
            public int previousIndex() {
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E getLast() {
        return this.get(this.size() - 1);
    }
}

