/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.intmatrix.calculation;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.entrywise.rounding.Round;
import org.ujmp.core.intmatrix.calculation.AbstractIntCalculation;
import org.ujmp.core.intmatrix.calculation.DiscretizeStandardBinning;

public class Discretize
extends AbstractIntCalculation {
    private static final long serialVersionUID = -2045926868254834270L;
    private Matrix discretized = null;

    public Discretize(Matrix matrix, int dimension, DiscretizationMethod method, int numberOfBins) {
        super(dimension, matrix);
        switch (method) {
            case ROUND: {
                this.discretized = new Round(matrix).calcLink();
                break;
            }
            case STANDARDBINNING: {
                this.discretized = new DiscretizeStandardBinning(dimension, matrix, numberOfBins).calcLink();
                break;
            }
            default: {
                throw new RuntimeException("method not yet implemented");
            }
        }
    }

    @Override
    public int getInt(long ... coordinates) {
        return this.discretized.getAsInt(coordinates);
    }

    public static enum DiscretizationMethod {
        ROUND,
        STRINGS,
        STANDARDBINNING,
        EQUALBINNING,
        INFORMATIONGAIN;

    }
}

