/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.filematrix;

import java.io.File;
import org.ujmp.core.Matrix;
import org.ujmp.core.filematrix.FileFormat;
import org.ujmp.core.filematrix.FileOrDirectoryMatrix;
import org.ujmp.core.objectmatrix.stub.AbstractObjectMatrix;

public class FileMatrix
extends AbstractObjectMatrix
implements FileOrDirectoryMatrix {
    private static final long serialVersionUID = -4912495890644097086L;
    private final File file;
    private Matrix matrix = null;

    public FileMatrix(String filename) {
        this(new File(filename));
    }

    public FileMatrix(File file) {
        super(0L, 0L);
        this.file = file;
        if (file == null) {
            this.setLabel("/");
        } else {
            this.setLabel(file.getName());
            this.setMetaData("Path", file.getPath());
            this.setMetaData("FileName", file.getName());
            this.setMetaData("CanExecute", file.canExecute());
            this.setMetaData("CanRead", file.canRead());
            this.setMetaData("CanWrite", file.canWrite());
            this.setMetaData("IsHidden", file.isHidden());
            this.setMetaData("IsDirectory", file.isDirectory());
            this.setMetaData("IsFile", file.isFile());
            this.setMetaData("LastModified", file.lastModified());
            this.setMetaData("Size", file.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadContent() {
        if (this.matrix == null) {
            FileMatrix fileMatrix = this;
            synchronized (fileMatrix) {
                if (this.matrix == null) {
                    try {
                        FileFormat format = FileFormat.guess(this.file);
                        this.setMetaData("FileFormat", (Object)format);
                        switch (format) {
                            case BMP: 
                            case GIF: 
                            case JPG: 
                            case JPEG2000: 
                            case PNG: 
                            case TIF: {
                                this.matrix = Matrix.Factory.linkToImage(this.file);
                                break;
                            }
                            case DB: {
                                this.matrix = Matrix.Factory.linkToJDBC(this.file);
                                break;
                            }
                            case ZIP: {
                                this.matrix = Matrix.Factory.linkToZipFile(this.file);
                                break;
                            }
                            case TXT: 
                            case CSV: {
                                this.matrix = Matrix.Factory.linkTo().file(this.file).asDenseCSV();
                                break;
                            }
                            default: {
                                this.matrix = Matrix.Factory.emptyMatrix();
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    @Override
    public boolean containsCoordinates(long ... coordinates) {
        this.loadContent();
        return this.matrix.containsCoordinates(coordinates);
    }

    @Override
    public boolean isSparse() {
        this.loadContent();
        return this.matrix.isSparse();
    }

    @Override
    public long[] getSize() {
        this.loadContent();
        this.size = this.matrix.getSize();
        return this.size;
    }

    @Override
    public Object getObject(long ... coordinates) {
        this.loadContent();
        return this.matrix.getAsObject(coordinates);
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        this.loadContent();
        return this.matrix.availableCoordinates();
    }

    @Override
    public final void clear() {
        this.matrix.clear();
    }
}

