/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.filematrix;

import java.io.File;
import org.ujmp.core.filematrix.FileMatrix;
import org.ujmp.core.filematrix.FileOrDirectoryMatrix;
import org.ujmp.core.listmatrix.AbstractListMatrix;

public class DirectoryMatrix
extends AbstractListMatrix<FileOrDirectoryMatrix>
implements FileOrDirectoryMatrix {
    private static final long serialVersionUID = -4912495890644097086L;
    private final File path;

    public DirectoryMatrix() {
        this((File)null);
    }

    public DirectoryMatrix(String path) {
        this(new File(path));
    }

    public DirectoryMatrix(File path) {
        this.path = path;
        if (path == null) {
            this.setLabel("/");
        } else {
            if (path.getParent() == null) {
                this.setLabel(path.getAbsolutePath());
            } else {
                this.setLabel(path.getName());
            }
            this.setMetaData("Path", path.getPath());
            this.setMetaData("FileName", path.getName());
            this.setMetaData("CanExecute", path.canExecute());
            this.setMetaData("CanRead", path.canRead());
            this.setMetaData("CanWrite", path.canWrite());
            this.setMetaData("IsHidden", path.isHidden());
            this.setMetaData("IsDirectory", path.isDirectory());
            this.setMetaData("IsFile", path.isFile());
            this.setMetaData("LastModified", path.lastModified());
            this.setMetaData("Size", path.length());
        }
    }

    @Override
    public FileOrDirectoryMatrix get(int index) {
        File[] files = null;
        files = this.path == null ? File.listRoots() : this.path.listFiles();
        if (files[index].isFile()) {
            return new FileMatrix(files[index]);
        }
        return new DirectoryMatrix(files[index]);
    }

    @Override
    public boolean addToList(FileOrDirectoryMatrix t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToList(int index, FileOrDirectoryMatrix element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirectoryMatrix removeFromList(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeFromList(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirectoryMatrix setToList(int index, FileOrDirectoryMatrix element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        if (this.path == null) {
            return File.listRoots().length;
        }
        File[] files = this.path.listFiles();
        return files == null ? 0 : files.length;
    }
}

