/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.impl;

import java.io.File;
import java.io.IOException;
import org.ujmp.core.doublematrix.impl.DenseFileMatrix;
import org.ujmp.core.util.UJMPFormat;

public class WaveMatrix
extends DenseFileMatrix {
    private static final long serialVersionUID = -4952985947339369630L;
    public static final int HEADERLENGTH = 44;
    private final boolean ignoreHeader = true;

    public WaveMatrix(String filename) throws IOException {
        this(new File(filename));
    }

    public WaveMatrix(File file) throws IOException {
        this(file, false);
    }

    public WaveMatrix(File file, boolean readOnly) throws IOException {
        super(file, 44L, 9, readOnly, 1L, 1L);
        this.setSize((int)(this.getDataLength() / (long)(this.getBitsPerSample() / 8) / (long)this.getChannels()), this.getChannels());
        System.out.println(this.toString());
    }

    public double getEstimatedMinValue(long timeOut) {
        return -32768.0;
    }

    public double getEstimatedMaxValue(long timeOut) {
        return 32768.0;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("RIFF Tag:         " + this.getRIFFTag() + "\n");
        s.append("WAVE Tag:         " + this.getWAVETag() + "\n");
        s.append("fmt  Tag:         " + this.getFmtTag() + "\n");
        s.append("data Tag:         " + this.getDataTag() + "\n");
        s.append("Format:           " + this.getFormat() + "\n");
        s.append("Channels:         " + this.getChannels() + "\n");
        s.append("SampleRate:       " + this.getSampleRate() + "\n");
        s.append("BitsPerSample:    " + this.getBitsPerSample() + "\n");
        s.append("BytesPerSecond:   " + this.getBytesPerSecond() + "\n");
        s.append("BlockAlign:       " + this.getBlockAlign() + "\n");
        s.append("DataLengthHeader: " + this.getDataLengthFromHeader() + "\n");
        s.append("DataLengthFile:   " + this.getDataLengthFromFile() + "\n");
        s.append("Duration:         " + UJMPFormat.getSingleLineInstance().format(this.getDuration()) + "s\n");
        s.append("RowCount:         " + this.getRowCount() + "\n");
        s.append("ColumnCount:      " + this.getColumnCount() + "\n");
        s.append("Header-Check:     " + (this.isWaveFile() ? "passed" : "error") + "\n");
        return s.toString();
    }

    public int getChannels() {
        byte[] bytes = new byte[2];
        try {
            this.getRandomAccessFile().read(22L, bytes);
            return WaveMatrix.getShortLittleEndian(bytes);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public double getDuration() {
        return (double)this.getDataLength() / (double)this.getBytesPerSecond();
    }

    public String getFormat() {
        byte[] bytes = new byte[2];
        try {
            this.getRandomAccessFile().read(20L, bytes);
            return WaveMatrix.getShortLittleEndian(bytes) == 1 ? "PCM" : "unknown";
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public String getFmtTag() {
        byte[] bytes = new byte[4];
        try {
            this.getRandomAccessFile().read(12L, bytes);
            return new String(bytes);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getDataTag() {
        byte[] bytes = new byte[4];
        try {
            this.getRandomAccessFile().read(36L, bytes);
            return new String(bytes);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getRIFFTag() {
        byte[] bytes = new byte[4];
        try {
            this.getRandomAccessFile().read(0L, bytes);
            return new String(bytes);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getWAVETag() {
        byte[] bytes = new byte[4];
        try {
            this.getRandomAccessFile().read(8L, bytes);
            return new String(bytes);
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean isWaveFile() {
        if (!"RIFF".equals(this.getRIFFTag())) {
            return false;
        }
        if (!"WAVE".equals(this.getWAVETag())) {
            return false;
        }
        if (!"fmt ".equals(this.getFmtTag())) {
            return false;
        }
        if (!"PCM".equals(this.getFormat())) {
            return false;
        }
        if (!"data".equals(this.getDataTag())) {
            return false;
        }
        return this.getBitsPerSample() == 8 || this.getBitsPerSample() == 16 || this.getBitsPerSample() == 32;
    }

    public int getBitsPerSample() {
        byte[] bytes = new byte[2];
        try {
            this.getRandomAccessFile().read(34L, bytes);
            return WaveMatrix.getShortLittleEndian(bytes);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getBlockAlign() {
        byte[] bytes = new byte[2];
        try {
            this.getRandomAccessFile().read(32L, bytes);
            return WaveMatrix.getShortLittleEndian(bytes);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getSampleRate() {
        byte[] bytes = new byte[4];
        try {
            this.getRandomAccessFile().read(24L, bytes);
            return WaveMatrix.getIntLittleEndian(bytes);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public long getDataLengthFromFile() {
        return this.getFile().length() - 44L;
    }

    public int getDataLengthFromHeader() {
        byte[] bytes = new byte[4];
        try {
            this.getRandomAccessFile().read(40L, bytes);
            return WaveMatrix.getIntLittleEndian(bytes);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public long getDataLength() {
        return this.getDataLengthFromFile();
    }

    public int getBytesPerSecond() {
        byte[] bytes = new byte[4];
        try {
            this.getRandomAccessFile().read(28L, bytes);
            return WaveMatrix.getIntLittleEndian(bytes);
        }
        catch (Exception e) {
            return 0;
        }
    }
}

