/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;

public class MortonDenseDoubleMartrix2D
extends AbstractDenseDoubleMatrix2D {
    private static final long serialVersionUID = -1951357825977485935L;
    public static final int ONES0 = -1431655766;
    public static final int ONES1 = 0x55555555;
    public static final int ONES0P1 = -1431655765;
    public static final int ONES1P1 = 0x55555556;
    public static final int[] TABLE0 = new int[Short.MAX_VALUE];
    public static final int[] TABLE1 = new int[Short.MAX_VALUE];
    private double[] values;
    private int rows;
    private int cols;

    public MortonDenseDoubleMartrix2D(Matrix m) {
        super(m.getRowCount(), m.getColumnCount());
        this.rows = MathUtil.longToInt(m.getRowCount());
        this.cols = MathUtil.longToInt(m.getColumnCount());
        int length = (int)Math.pow(Math.pow(2.0, Math.ceil(MathUtil.log2(Math.max(this.rows, this.cols)))), 2.0);
        if (m instanceof MortonDenseDoubleMartrix2D) {
            double[] v = ((MortonDenseDoubleMartrix2D)m).values;
            this.values = new double[length];
            System.arraycopy(v, 0, this.values, 0, v.length);
        } else {
            this.values = new double[length];
            for (long[] c : m.allCoordinates()) {
                this.setDouble(m.getAsDouble(c), c);
            }
        }
        if (m.getMetaData() != null) {
            this.setMetaData((MapMatrix<String, Object>)m.getMetaData().clone());
        }
    }

    public MortonDenseDoubleMartrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.rows = rows;
        this.cols = columns;
        this.size = new long[]{rows, columns};
        int length = (int)Math.pow(Math.pow(2.0, Math.ceil(MathUtil.log2(Math.max(rows, columns)))), 2.0);
        this.values = new double[length];
    }

    public MortonDenseDoubleMartrix2D(double[] v, int rows, int cols) {
        super((long)rows, (long)cols);
        this.rows = rows;
        this.cols = cols;
        this.size = new long[]{rows, cols};
        this.values = v;
    }

    @Override
    public final double getDouble(long row, long column) {
        return this.values[TABLE1[(int)row] + TABLE0[(int)column]];
    }

    @Override
    public final double getAsDouble(long row, long column) {
        return this.values[TABLE1[(int)row] + TABLE0[(int)column]];
    }

    @Override
    public final double getAsDouble(int row, int column) {
        return this.values[TABLE1[row] + TABLE0[column]];
    }

    @Override
    public final void setDouble(double value, long row, long column) {
        this.values[MortonDenseDoubleMartrix2D.TABLE1[(int)row] + MortonDenseDoubleMartrix2D.TABLE0[(int)column]] = value;
    }

    @Override
    public final void setAsDouble(double value, long row, long column) {
        this.values[MortonDenseDoubleMartrix2D.TABLE1[(int)row] + MortonDenseDoubleMartrix2D.TABLE0[(int)column]] = value;
    }

    @Override
    public final double getDouble(int row, int column) {
        return this.values[TABLE1[row] + TABLE0[column]];
    }

    @Override
    public final void setDouble(double value, int row, int column) {
        this.values[MortonDenseDoubleMartrix2D.TABLE1[row] + MortonDenseDoubleMartrix2D.TABLE0[column]] = value;
    }

    @Override
    public final void setAsDouble(double value, int row, int column) {
        this.values[MortonDenseDoubleMartrix2D.TABLE1[row] + MortonDenseDoubleMartrix2D.TABLE0[column]] = value;
    }

    public final Matrix copy() {
        double[] result = new double[this.values.length];
        System.arraycopy(this.values, 0, result, 0, this.values.length);
        MortonDenseDoubleMartrix2D m = new MortonDenseDoubleMartrix2D(result, this.rows, this.cols);
        if (this.getMetaData() != null) {
            m.setMetaData((MapMatrix<String, Object>)this.getMetaData().clone());
        }
        return m;
    }

    @Override
    public Matrix mtimes(Matrix m2) {
        if (m2 instanceof MortonDenseDoubleMartrix2D) {
            MortonDenseDoubleMartrix2D ret = new MortonDenseDoubleMartrix2D(MathUtil.longToInt(this.getRowCount()), MathUtil.longToInt(m2.getColumnCount()));
            double[] c = ret.values;
            double[] b = ((MortonDenseDoubleMartrix2D)m2).values;
            int retcols = ret.cols;
            int table1rows = TABLE1[this.rows];
            int table0cols = TABLE0[this.cols];
            int table0retcols = TABLE0[retcols];
            int i = 0;
            while (i < table1rows) {
                int k0 = 0;
                while (k0 < table0cols) {
                    int k1 = k0 << 1;
                    double r = this.values[i + k0];
                    int j = 0;
                    while (j < table0retcols) {
                        int n = i + j;
                        c[n] = c[n] + r * b[k1 + j];
                        j = j + -1431655765 & 0x55555555;
                    }
                    k0 = k0 + -1431655765 & 0x55555555;
                }
                i = i + 0x55555556 & 0xAAAAAAAA;
            }
            return ret;
        }
        return super.mtimes(m2);
    }

    public static final void init() {
        int i;
        int v = 0;
        int length = TABLE0.length;
        for (i = 0; i < length; ++i) {
            MortonDenseDoubleMartrix2D.TABLE0[i] = v;
            v = v + -1431655765 & 0x55555555;
        }
        v = 0;
        length = TABLE1.length;
        for (i = 0; i < length; ++i) {
            MortonDenseDoubleMartrix2D.TABLE1[i] = v;
            v = v + 0x55555556 & 0xAAAAAAAA;
        }
    }

    static {
        MortonDenseDoubleMartrix2D.init();
    }
}

