/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.statistical;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;

public class Max
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -132801357103800951L;

    public Max(int dimension, Matrix matrix) {
        super(dimension, matrix);
        MapMatrix<String, Object> aold = matrix.getMetaData();
        if (aold != null) {
            DefaultMapMatrix<String, Object> a = new DefaultMapMatrix<String, Object>();
            a.put("Label", aold.get("Label"));
            if (dimension == 0 || dimension == 1) {
                // empty if block
            }
            this.setMetaData(a);
        }
    }

    @Override
    public double getDouble(long ... coordinates) {
        double max = -1.7976931348623157E308;
        switch (this.getDimension()) {
            case 0: {
                for (long r = this.getSource().getSize()[0] - 1L; r != -1L; --r) {
                    long[] lArray = new long[]{r, coordinates[1]};
                    double v = this.getSource().getAsDouble(lArray);
                    if (!(v > max)) continue;
                    max = v;
                }
                max = max == -1.7976931348623157E308 ? Double.NaN : max;
                return max;
            }
            case 1: {
                for (long c = this.getSource().getSize()[1] - 1L; c != -1L; --c) {
                    long[] lArray = new long[]{coordinates[0], c};
                    double v = this.getSource().getAsDouble(lArray);
                    if (!(v > max)) continue;
                    max = v;
                }
                max = max == -1.7976931348623157E308 ? Double.NaN : max;
                return max;
            }
            case 0x7FFFFFFF: {
                for (long r = this.getSource().getSize()[0] - 1L; r != -1L; --r) {
                    for (long c = this.getSource().getSize()[1] - 1L; c != -1L; --c) {
                        long[] lArray = new long[]{r, c};
                        double v = this.getSource().getAsDouble(lArray);
                        if (!(v > max)) continue;
                        max = v;
                    }
                }
                max = max == -1.7976931348623157E308 ? Double.NaN : max;
                return max;
            }
        }
        return 0.0;
    }

    @Override
    public long[] getSize() {
        switch (this.getDimension()) {
            case 0: {
                return new long[]{1L, this.getSource().getSize()[1]};
            }
            case 1: {
                return new long[]{this.getSource().getSize()[0], 1L};
            }
            case 0x7FFFFFFF: {
                return new long[]{1L, 1L};
            }
        }
        throw new RuntimeException("dimension not supported: " + this.getDimension());
    }

    public static double calc(Matrix m) {
        double max = -1.7976931348623157E308;
        double v = 0.0;
        for (long[] c : m.availableCoordinates()) {
            double d;
            v = m.getAsDouble(c);
            max = d > max ? v : max;
        }
        max = max == -1.7976931348623157E308 ? Double.NaN : max;
        return max;
    }
}

