/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.misc;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;

public class FadeOut
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -2366094848097068297L;

    public FadeOut(int dimension, Matrix matrix) {
        super(dimension, matrix);
    }

    @Override
    public double getDouble(long ... coordinates) {
        double factor = 0.0;
        switch (this.getDimension()) {
            case 1: {
                factor = 1.0 - (double)coordinates[1] / (double)(this.getSource().getColumnCount() - 1L);
                break;
            }
            case 0: {
                factor = 1.0 - (double)coordinates[0] / (double)(this.getSource().getRowCount() - 1L);
                break;
            }
            default: {
                factor = 1.0 - (double)Coordinates.product(coordinates) / (double)(this.getSource().getRowCount() - 1L);
            }
        }
        return this.getSource().getAsDouble(coordinates) * factor;
    }
}

