/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.misc;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.statistical.Mean;

public class Center
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -2400183861312141152L;
    private Matrix mean = null;
    private boolean ignoreNaN = false;

    public Center(boolean ignoreNaN, int dimension, Matrix matrix) {
        super(dimension, matrix);
        this.ignoreNaN = ignoreNaN;
    }

    @Override
    public double getDouble(long ... coordinates) {
        if (this.mean == null) {
            this.mean = new Mean(this.getDimension(), this.ignoreNaN, this.getSource()).calcNew();
        }
        switch (this.getDimension()) {
            case 0x7FFFFFFF: {
                return this.getSource().getAsDouble(coordinates) - this.mean.getAsDouble(0L, 0L);
            }
            case 0: {
                return this.getSource().getAsDouble(coordinates) - this.mean.getAsDouble(0L, coordinates[1]);
            }
            case 1: {
                return this.getSource().getAsDouble(coordinates) - this.mean.getAsDouble(coordinates[0], 0L);
            }
        }
        return Double.NaN;
    }
}

