/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.decomposition;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.util.DecompositionOps;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPSettings;

public interface SVD<T> {
    public static final int THRESHOLD = 100;
    public static final SVD<Matrix> MATRIX = new SVD<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            if (UJMPSettings.getInstance().getNumberOfThreads() == 1) {
                if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                    return MATRIXLARGESINGLETHREADED.calc(source);
                }
                return MATRIXSMALLSINGLETHREADED.calc(source);
            }
            if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                return MATRIXLARGEMULTITHREADED.calc(source);
            }
            return MATRIXSMALLMULTITHREADED.calc(source);
        }
    };
    public static final SVD<Matrix> INSTANCE = MATRIX;
    public static final SVD<Matrix> UJMP = new SVD<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            SVDMatrix svd = new SVDMatrix(source);
            return new Matrix[]{svd.getU(), svd.getS(), svd.getV()};
        }
    };
    public static final SVD<Matrix> MATRIXSMALLSINGLETHREADED = UJMP;
    public static final SVD<Matrix> MATRIXLARGESINGLETHREADED = new SVD<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            SVD<Matrix> svd = null;
            if (UJMPSettings.getInstance().isUseMTJ()) {
                svd = DecompositionOps.SVD_MTJ;
            }
            if (svd == null && UJMPSettings.getInstance().isUseOjalgo()) {
                svd = DecompositionOps.SVD_OJALGO;
            }
            if (svd == null && UJMPSettings.getInstance().isUseEJML()) {
                svd = DecompositionOps.SVD_EJML;
            }
            if (svd == null) {
                svd = UJMP;
            }
            return svd.calc(source);
        }
    };
    public static final SVD<Matrix> MATRIXSMALLMULTITHREADED = UJMP;
    public static final SVD<Matrix> MATRIXLARGEMULTITHREADED = new SVD<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            SVD<Matrix> svd = null;
            if (UJMPSettings.getInstance().isUseOjalgo()) {
                svd = DecompositionOps.SVD_OJALGO;
            }
            if (svd == null && UJMPSettings.getInstance().isUseMTJ()) {
                svd = DecompositionOps.SVD_MTJ;
            }
            if (svd == null && UJMPSettings.getInstance().isUseEJML()) {
                svd = DecompositionOps.SVD_EJML;
            }
            if (svd == null) {
                svd = UJMP;
            }
            return svd.calc(source);
        }
    };

    public T[] calc(T var1);

    public static final class SVDMatrix {
        private static final double EPSILON = Math.pow(2.0, -52.0);
        private static final double TINY = Math.pow(2.0, -966.0);
        private final double[][] U;
        private final double[][] V;
        private final double[] s;
        private final int m;
        private final int n;
        private final int ncu;
        private final boolean thin;

        public SVDMatrix(Matrix Arg) {
            this(Arg, true, true, true);
        }

        public SVDMatrix(Matrix Arg, boolean thin, boolean wantu, boolean wantv) {
            int i;
            double t;
            int k;
            int j;
            if (Arg.containsMissingValues()) {
                throw new RuntimeException("matrix contains missing values");
            }
            double[][] A = Arg.toDoubleArray();
            this.m = (int)Arg.getRowCount();
            this.n = (int)Arg.getColumnCount();
            this.thin = thin;
            this.ncu = thin ? Math.min(this.m, this.n) : this.m;
            this.s = new double[Math.min(this.m + 1, this.n)];
            this.U = new double[this.m][this.ncu];
            this.V = new double[this.n][this.n];
            double[] e = new double[this.n];
            double[] work = new double[this.m];
            int nct = Math.min(this.m - 1, this.n);
            int nrt = Math.max(0, Math.min(this.n - 2, this.m));
            int lu = Math.max(nct, nrt);
            for (int k2 = 0; k2 < lu; ++k2) {
                int i2;
                int i3;
                if (k2 < nct) {
                    this.s[k2] = 0.0;
                    for (i3 = k2; i3 < this.m; ++i3) {
                        this.s[k2] = MathUtil.hypot(this.s[k2], A[i3][k2]);
                    }
                    if (this.s[k2] != 0.0) {
                        if (A[k2][k2] < 0.0) {
                            this.s[k2] = -this.s[k2];
                        }
                        for (i3 = k2; i3 < this.m; ++i3) {
                            double[] dArray = A[i3];
                            int n = k2;
                            dArray[n] = dArray[n] / this.s[k2];
                        }
                        double[] dArray = A[k2];
                        int n = k2;
                        dArray[n] = dArray[n] + 1.0;
                    }
                    this.s[k2] = -this.s[k2];
                }
                for (j = k2 + 1; j < this.n; ++j) {
                    if (k2 < nct & this.s[k2] != 0.0) {
                        double t2 = 0.0;
                        for (i2 = k2; i2 < this.m; ++i2) {
                            t2 += A[i2][k2] * A[i2][j];
                        }
                        t2 = -t2 / A[k2][k2];
                        for (i2 = k2; i2 < this.m; ++i2) {
                            double[] dArray = A[i2];
                            int n = j;
                            dArray[n] = dArray[n] + t2 * A[i2][k2];
                        }
                    }
                    e[j] = A[k2][j];
                }
                if (wantu & k2 < nct) {
                    for (i3 = k2; i3 < this.m; ++i3) {
                        this.U[i3][k2] = A[i3][k2];
                    }
                }
                if (k2 >= nrt) continue;
                e[k2] = 0.0;
                for (i3 = k2 + 1; i3 < this.n; ++i3) {
                    e[k2] = MathUtil.hypot(e[k2], e[i3]);
                }
                if (e[k2] != 0.0) {
                    if (e[k2 + 1] < 0.0) {
                        e[k2] = -e[k2];
                    }
                    i3 = k2 + 1;
                    while (i3 < this.n) {
                        int n = i3++;
                        e[n] = e[n] / e[k2];
                    }
                    int n = k2 + 1;
                    e[n] = e[n] + 1.0;
                }
                e[k2] = -e[k2];
                if (k2 + 1 < this.m & e[k2] != 0.0) {
                    for (i3 = k2 + 1; i3 < this.m; ++i3) {
                        work[i3] = 0.0;
                    }
                    for (j = k2 + 1; j < this.n; ++j) {
                        for (int i4 = k2 + 1; i4 < this.m; ++i4) {
                            int n = i4;
                            work[n] = work[n] + e[j] * A[i4][j];
                        }
                    }
                    for (j = k2 + 1; j < this.n; ++j) {
                        double t3 = -e[j] / e[k2 + 1];
                        for (i2 = k2 + 1; i2 < this.m; ++i2) {
                            double[] dArray = A[i2];
                            int n = j;
                            dArray[n] = dArray[n] + t3 * work[i2];
                        }
                    }
                }
                if (!wantv) continue;
                for (i3 = k2 + 1; i3 < this.n; ++i3) {
                    this.V[i3][k2] = e[i3];
                }
            }
            int p = Math.min(this.n, this.m + 1);
            if (nct < this.n) {
                this.s[nct] = A[nct][nct];
            }
            if (this.m < p) {
                this.s[p - 1] = 0.0;
            }
            if (nrt + 1 < p) {
                e[nrt] = A[nrt][p - 1];
            }
            e[p - 1] = 0.0;
            if (wantu) {
                for (j = nct; j < this.ncu; ++j) {
                    for (int i5 = 0; i5 < this.m; ++i5) {
                        this.U[i5][j] = 0.0;
                    }
                    this.U[j][j] = 1.0;
                }
                for (k = nct - 1; k >= 0; --k) {
                    int i6;
                    if (this.s[k] != 0.0) {
                        for (int j2 = k + 1; j2 < this.ncu; ++j2) {
                            t = 0.0;
                            for (i = k; i < this.m; ++i) {
                                t += this.U[i][k] * this.U[i][j2];
                            }
                            t = -t / this.U[k][k];
                            for (i = k; i < this.m; ++i) {
                                double[] dArray = this.U[i];
                                int n = j2;
                                dArray[n] = dArray[n] + t * this.U[i][k];
                            }
                        }
                        for (i6 = k; i6 < this.m; ++i6) {
                            this.U[i6][k] = -this.U[i6][k];
                        }
                        double[] dArray = this.U[k];
                        int n = k;
                        dArray[n] = dArray[n] + 1.0;
                        for (i6 = 0; i6 < k - 1; ++i6) {
                            this.U[i6][k] = 0.0;
                        }
                        continue;
                    }
                    for (i6 = 0; i6 < this.m; ++i6) {
                        this.U[i6][k] = 0.0;
                    }
                    this.U[k][k] = 1.0;
                }
            }
            if (wantv) {
                for (k = this.n - 1; k >= 0; --k) {
                    if (k < nrt & e[k] != 0.0) {
                        for (int j3 = k + 1; j3 < this.n; ++j3) {
                            t = 0.0;
                            for (i = k + 1; i < this.n; ++i) {
                                t += this.V[i][k] * this.V[i][j3];
                            }
                            t = -t / this.V[k + 1][k];
                            for (i = k + 1; i < this.n; ++i) {
                                double[] dArray = this.V[i];
                                int n = j3;
                                dArray[n] = dArray[n] + t * this.V[i][k];
                            }
                        }
                    }
                    for (int i7 = 0; i7 < this.n; ++i7) {
                        this.V[i7][k] = 0.0;
                    }
                    this.V[k][k] = 1.0;
                }
            }
            int pp = p - 1;
            block35: while (p > 0) {
                int kase;
                int k3;
                for (k3 = p - 2; k3 >= -1 && k3 != -1; --k3) {
                    if (!(Math.abs(e[k3]) <= TINY + EPSILON * (Math.abs(this.s[k3]) + Math.abs(this.s[k3 + 1])))) continue;
                    e[k3] = 0.0;
                    break;
                }
                if (k3 == p - 2) {
                    kase = 4;
                } else {
                    int ks;
                    for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                        double t4 = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? Math.abs(e[ks - 1]) : 0.0);
                        if (!(Math.abs(this.s[ks]) <= TINY + EPSILON * t4)) continue;
                        this.s[ks] = 0.0;
                        break;
                    }
                    if (ks == k3) {
                        kase = 3;
                    } else if (ks == p - 1) {
                        kase = 1;
                    } else {
                        kase = 2;
                        k3 = ks;
                    }
                }
                ++k3;
                switch (kase) {
                    case 1: {
                        int i8;
                        double sn;
                        double cs;
                        double t5;
                        double f = e[p - 2];
                        e[p - 2] = 0.0;
                        for (int j4 = p - 2; j4 >= k3; --j4) {
                            t5 = MathUtil.hypot(this.s[j4], f);
                            cs = this.s[j4] / t5;
                            sn = f / t5;
                            this.s[j4] = t5;
                            if (j4 != k3) {
                                f = -sn * e[j4 - 1];
                                e[j4 - 1] = cs * e[j4 - 1];
                            }
                            if (!wantv) continue;
                            for (i8 = 0; i8 < this.n; ++i8) {
                                t5 = cs * this.V[i8][j4] + sn * this.V[i8][p - 1];
                                this.V[i8][p - 1] = -sn * this.V[i8][j4] + cs * this.V[i8][p - 1];
                                this.V[i8][j4] = t5;
                            }
                        }
                        continue block35;
                    }
                    case 2: {
                        int i8;
                        double sn;
                        double cs;
                        double t5;
                        double f = e[k3 - 1];
                        e[k3 - 1] = 0.0;
                        for (int j5 = k3; j5 < p; ++j5) {
                            t5 = MathUtil.hypot(this.s[j5], f);
                            cs = this.s[j5] / t5;
                            sn = f / t5;
                            this.s[j5] = t5;
                            f = -sn * e[j5];
                            e[j5] = cs * e[j5];
                            if (!wantu) continue;
                            for (i8 = 0; i8 < this.m; ++i8) {
                                t5 = cs * this.U[i8][j5] + sn * this.U[i8][k3 - 1];
                                this.U[i8][k3 - 1] = -sn * this.U[i8][j5] + cs * this.U[i8][k3 - 1];
                                this.U[i8][j5] = t5;
                            }
                        }
                        continue block35;
                    }
                    case 3: {
                        double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[p - 1]), Math.abs(this.s[p - 2])), Math.abs(e[p - 2])), Math.abs(this.s[k3])), Math.abs(e[k3]));
                        double sp = this.s[p - 1] / scale;
                        double spm1 = this.s[p - 2] / scale;
                        double epm1 = e[p - 2] / scale;
                        double sk = this.s[k3] / scale;
                        double ek = e[k3] / scale;
                        double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                        double c = sp * epm1 * (sp * epm1);
                        double shift = 0.0;
                        if (b != 0.0 | c != 0.0) {
                            shift = Math.sqrt(b * b + c);
                            if (b < 0.0) {
                                shift = -shift;
                            }
                            shift = c / (b + shift);
                        }
                        double f = (sk + sp) * (sk - sp) + shift;
                        double g = sk * ek;
                        for (int j6 = k3; j6 < p - 1; ++j6) {
                            int i9;
                            double t6 = MathUtil.hypot(f, g);
                            double cs = f / t6;
                            double sn = g / t6;
                            if (j6 != k3) {
                                e[j6 - 1] = t6;
                            }
                            f = cs * this.s[j6] + sn * e[j6];
                            e[j6] = cs * e[j6] - sn * this.s[j6];
                            g = sn * this.s[j6 + 1];
                            this.s[j6 + 1] = cs * this.s[j6 + 1];
                            if (wantv) {
                                for (i9 = 0; i9 < this.n; ++i9) {
                                    t6 = cs * this.V[i9][j6] + sn * this.V[i9][j6 + 1];
                                    this.V[i9][j6 + 1] = -sn * this.V[i9][j6] + cs * this.V[i9][j6 + 1];
                                    this.V[i9][j6] = t6;
                                }
                            }
                            t6 = MathUtil.hypot(f, g);
                            cs = f / t6;
                            sn = g / t6;
                            this.s[j6] = t6;
                            f = cs * e[j6] + sn * this.s[j6 + 1];
                            this.s[j6 + 1] = -sn * e[j6] + cs * this.s[j6 + 1];
                            g = sn * e[j6 + 1];
                            e[j6 + 1] = cs * e[j6 + 1];
                            if (!wantu || j6 >= this.m - 1) continue;
                            for (i9 = 0; i9 < this.m; ++i9) {
                                t6 = cs * this.U[i9][j6] + sn * this.U[i9][j6 + 1];
                                this.U[i9][j6 + 1] = -sn * this.U[i9][j6] + cs * this.U[i9][j6 + 1];
                                this.U[i9][j6] = t6;
                            }
                        }
                        e[p - 2] = f;
                        break;
                    }
                    case 4: {
                        if (this.s[k3] <= 0.0) {
                            double d = this.s[k3] = this.s[k3] < 0.0 ? -this.s[k3] : 0.0;
                            if (wantv) {
                                for (int i10 = 0; i10 < this.n; ++i10) {
                                    this.V[i10][k3] = -this.V[i10][k3];
                                }
                            }
                        }
                        while (k3 < pp && !(this.s[k3] >= this.s[k3 + 1])) {
                            int i11;
                            double t7 = this.s[k3];
                            this.s[k3] = this.s[k3 + 1];
                            this.s[k3 + 1] = t7;
                            if (wantv && k3 < this.n - 1) {
                                for (i11 = 0; i11 < this.n; ++i11) {
                                    t7 = this.V[i11][k3 + 1];
                                    this.V[i11][k3 + 1] = this.V[i11][k3];
                                    this.V[i11][k3] = t7;
                                }
                            }
                            if (wantu && k3 < this.m - 1) {
                                for (i11 = 0; i11 < this.m; ++i11) {
                                    t7 = this.U[i11][k3 + 1];
                                    this.U[i11][k3 + 1] = this.U[i11][k3];
                                    this.U[i11][k3] = t7;
                                }
                            }
                            ++k3;
                        }
                        --p;
                    }
                }
            }
        }

        public final DenseDoubleMatrix2D getU() {
            double[][] x = new double[this.m][this.m >= this.n ? (this.thin ? Math.min(this.m + 1, this.n) : this.ncu) : this.ncu];
            for (int r = 0; r < this.m; ++r) {
                int c = x[0].length;
                while (--c >= 0) {
                    x[r][c] = this.U[r][c];
                }
            }
            return Matrix.Factory.linkToArray(x);
        }

        public final DenseDoubleMatrix2D getV() {
            return this.V == null ? null : Matrix.Factory.linkToArray(this.V);
        }

        public final double[] getSingularValues() {
            return this.s;
        }

        public final DenseDoubleMatrix2D getS() {
            double[][] X = new double[this.m >= this.n ? (this.thin ? this.n : this.ncu) : this.ncu][this.n];
            int i = Math.min(this.m, this.n);
            while (--i >= 0) {
                X[i][i] = this.s[i];
            }
            return Matrix.Factory.linkToArray(X);
        }

        public final DenseDoubleMatrix2D getreciprocalS() {
            double[][] X = new double[this.n][this.m >= this.n ? (this.thin ? this.n : this.ncu) : this.ncu];
            for (int i = Math.min(this.m, this.n) - 1; i >= 0; --i) {
                X[i][i] = this.s[i] == 0.0 ? 0.0 : 1.0 / this.s[i];
            }
            return Matrix.Factory.linkToArray(X);
        }

        public final DenseDoubleMatrix2D inverse(boolean omit) {
            double[][] inverse = new double[this.n][this.m];
            if (this.rank() > 0) {
                double[] reciprocalS = new double[this.s.length];
                if (omit) {
                    double tol = (double)Math.max(this.m, this.n) * this.s[0] * EPSILON;
                    for (int i = this.s.length - 1; i >= 0; --i) {
                        reciprocalS[i] = Math.abs(this.s[i]) < tol ? 0.0 : 1.0 / this.s[i];
                    }
                } else {
                    for (int i = this.s.length - 1; i >= 0; --i) {
                        reciprocalS[i] = this.s[i] == 0.0 ? 0.0 : 1.0 / this.s[i];
                    }
                }
                int min = Math.min(this.n, this.ncu);
                for (int i = this.n - 1; i >= 0; --i) {
                    for (int j = this.m - 1; j >= 0; --j) {
                        for (int k = min - 1; k >= 0; --k) {
                            double[] dArray = inverse[i];
                            int n = j;
                            dArray[n] = dArray[n] + this.V[i][k] * reciprocalS[k] * this.U[j][k];
                        }
                    }
                }
            }
            return Matrix.Factory.linkToArray(inverse);
        }

        public final double norm2() {
            return this.s[0];
        }

        public final double cond() {
            return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
        }

        public final int rank() {
            double tol = (double)Math.max(this.m, this.n) * this.s[0] * EPSILON;
            int r = 0;
            for (int i = 0; i < this.s.length; ++i) {
                if (!(this.s[i] > tol)) continue;
                ++r;
            }
            return r;
        }
    }
}

