/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.entrywise.creators;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;

public class Range
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 3668085917153961068L;
    private double min = 0.0;
    private double stepSize = 1.0;
    private double max = 0.0;

    public Range(Matrix matrix, double min, double stepSize, double max) {
        super(matrix);
        this.min = min;
        this.stepSize = stepSize;
        this.max = max;
    }

    @Override
    public double getDouble(long ... coordinates) {
        return this.min + (double)coordinates[1] * this.stepSize;
    }

    @Override
    public long[] getSize() {
        long cols = (long)Math.floor((this.max - this.min) / this.stepSize) + 1L;
        return new long[]{1L, cols};
    }
}

