/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections.map;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.ujmp.core.collections.map.AbstractDiskMap;
import org.ujmp.core.util.SerializationUtil;

public class SerializedObjectMap<K, V>
extends AbstractDiskMap<K, V> {
    private static final long serialVersionUID = -1969661697021465379L;

    public SerializedObjectMap() throws IOException {
        this((File)null, true);
    }

    public SerializedObjectMap(String path) throws IOException {
        this(new File(path), true);
    }

    public SerializedObjectMap(boolean useGZip) throws IOException {
        this((File)null, useGZip);
    }

    public SerializedObjectMap(String path, boolean useGZip) throws IOException {
        this(new File(path), useGZip);
    }

    public SerializedObjectMap(File path) throws IOException {
        this(path, true);
    }

    public SerializedObjectMap(File path, boolean useGZip) throws IOException {
        super(path, useGZip);
    }

    @Override
    public final void writeValue(OutputStream os, V value) {
        try {
            SerializationUtil.serialize((Serializable)value, os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public V readValue(InputStream is) {
        try {
            return (V)SerializationUtil.deserialize(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

