/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.DenseMatrix2D;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.TimesScalar;
import org.ujmp.core.calculation.TimesScalarCalculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.VerifyUtil;

class TimesScalarDenseMatrix2D
implements TimesScalarCalculation<DenseMatrix2D, DenseMatrix2D> {
    TimesScalarDenseMatrix2D() {
    }

    @Override
    public final void calc(DenseMatrix2D source, BigDecimal factor, DenseMatrix2D target) {
        if (source instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
            TimesScalar.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source, factor, (DenseDoubleMatrix2D)target);
        } else {
            MapMatrix<String, Object> a;
            VerifyUtil.verifySameSize((Matrix)source, (Matrix)target);
            int r = (int)source.getRowCount();
            while (--r != -1) {
                int c = (int)source.getColumnCount();
                while (--c != -1) {
                    BigDecimal value = source.getAsBigDecimal(r, c);
                    BigDecimal result = MathUtil.times(value, factor);
                    target.setAsBigDecimal(result, r, c);
                }
            }
            if (source != target && (a = source.getMetaData()) != null) {
                target.setMetaData((MapMatrix<String, Object>)a.clone());
            }
        }
    }

    @Override
    public final void calc(DenseMatrix2D source, double factor, DenseMatrix2D target) {
        if (source instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
            TimesScalar.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source, factor, (DenseDoubleMatrix2D)target);
        } else {
            this.calc(source, new BigDecimal(factor, UJMPSettings.getInstance().getMathContext()), target);
        }
    }
}

