/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.SparseMatrix;
import org.ujmp.core.calculation.PlusScalarCalculation;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.VerifyUtil;

class PlusScalarSparseMatrix
implements PlusScalarCalculation<SparseMatrix, SparseMatrix> {
    PlusScalarSparseMatrix() {
    }

    @Override
    public final void calc(SparseMatrix source, BigDecimal value, SparseMatrix target) {
        MapMatrix<String, Object> a;
        VerifyUtil.verifySameSize((Matrix)source, (Matrix)target);
        for (long[] c : source.availableCoordinates()) {
            BigDecimal svalue = source.getAsBigDecimal(c);
            BigDecimal result = MathUtil.plus(svalue, value);
            target.setAsBigDecimal(result, c);
        }
        if (source != target && (a = source.getMetaData()) != null) {
            target.setMetaData((MapMatrix<String, Object>)a.clone());
        }
    }

    @Override
    public final void calc(SparseMatrix source, double value, SparseMatrix target) {
        this.calc(source, new BigDecimal(value, UJMPSettings.getInstance().getMathContext()), target);
    }
}

