/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.benchmark;

import java.io.File;
import java.util.List;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.benchmark.BenchmarkConfig;
import org.ujmp.core.benchmark.BenchmarkResult;
import org.ujmp.core.benchmark.BenchmarkUtil;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.stringmatrix.StringMatrix;
import org.ujmp.core.stringmatrix.StringMatrix2D;
import org.ujmp.core.util.MathUtil;

public abstract class AbstractBenchmarkTask {
    private BenchmarkConfig config = null;
    private Class<? extends Matrix> matrixClass = null;
    private List<long[]> sizes = null;
    private long benchmarkSeed = 0L;

    public AbstractBenchmarkTask(long benchmarkSeed, Class<? extends Matrix> matrixClass, List<long[]> sizes, BenchmarkConfig config) {
        this.matrixClass = matrixClass;
        this.config = config;
        this.sizes = sizes;
    }

    public BenchmarkConfig getConfig() {
        return this.config;
    }

    public void run() {
        File timeFile = new File(BenchmarkUtil.getResultDir(this.getConfig()) + this.getMatrixLabel() + "/" + this.getTaskName() + ".csv");
        File diffFile = new File(BenchmarkUtil.getResultDir(this.getConfig()) + this.getMatrixLabel() + "/" + this.getTaskName() + "-diff.csv");
        File memFile = new File(BenchmarkUtil.getResultDir(this.getConfig()) + this.getMatrixLabel() + "/" + this.getTaskName() + "-mem.csv");
        if (timeFile.exists()) {
            System.out.println("old results available, skipping " + this.getTaskName() + " for " + this.getMatrixLabel());
            return;
        }
        StringMatrix2D resultTime = StringMatrix.Factory.zeros((long)this.config.getRuns(), (long)this.sizes.size());
        StringMatrix2D resultDiff = StringMatrix.Factory.zeros((long)this.config.getRuns(), (long)this.sizes.size());
        StringMatrix2D resultMem = StringMatrix.Factory.zeros((long)this.config.getRuns(), (long)this.sizes.size());
        resultTime.setLabel(this.getMatrixLabel() + "-" + this.getTaskName());
        resultDiff.setLabel(this.getMatrixLabel() + "-" + this.getTaskName() + "-diff");
        resultMem.setLabel(this.getMatrixLabel() + "-" + this.getTaskName() + "-mem");
        for (int s = 0; s < this.sizes.size(); ++s) {
            long[] size = this.sizes.get(s);
            resultTime.setColumnLabel(s, String.valueOf(size[0]));
            resultDiff.setColumnLabel(s, String.valueOf(size[0]));
            resultMem.setColumnLabel(s, String.valueOf(size[0]));
        }
        boolean stopped = false;
        for (int s = 0; !stopped && s < this.sizes.size(); ++s) {
            long[] size = this.sizes.get(s);
            double bestStd = Double.MAX_VALUE;
            int tmpTrialCount = this.config.getMinTrialCount();
            DenseDoubleMatrix2D curTime = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros((long)this.config.getRuns(), 1L);
            DenseDoubleMatrix2D bestTime = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros((long)this.config.getRuns(), 1L);
            DenseDoubleMatrix2D curDiff = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros((long)this.config.getRuns(), 1L);
            DenseDoubleMatrix2D bestDiff = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros((long)this.config.getRuns(), 1L);
            DenseDoubleMatrix2D curMem = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros((long)this.config.getRuns(), 1L);
            DenseDoubleMatrix2D bestMem = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros((long)this.config.getRuns(), 1L);
            for (int c = 0; !stopped && c < tmpTrialCount; ++c) {
                double t;
                BenchmarkResult r;
                long t0;
                int i;
                System.out.print(this.getTaskName() + " [" + Coordinates.toString("x", size) + "] ");
                System.out.print(c + 1 + "/" + tmpTrialCount + ": ");
                System.out.flush();
                for (i = 0; !stopped && i < this.config.getBurnInRuns(); ++i) {
                    t0 = System.currentTimeMillis();
                    r = this.task(this.matrixClass, this.benchmarkSeed + (long)c, i, size);
                    t = r.getTime();
                    long t1 = System.currentTimeMillis();
                    if (t == 0.0 || Double.isNaN(t) || t1 - t0 > (long)this.config.getMaxTime()) {
                        stopped = true;
                    }
                    System.out.print("#");
                    System.out.flush();
                }
                for (i = 0; !stopped && i < this.config.getRuns(); ++i) {
                    t0 = System.currentTimeMillis();
                    r = this.task(this.matrixClass, this.benchmarkSeed + (long)c, i, size);
                    t = r.getTime();
                    double diff = r.getDifference();
                    long mem = r.getMem();
                    long t1 = System.currentTimeMillis();
                    if (t == 0.0 || Double.isNaN(t) || t1 - t0 > (long)this.config.getMaxTime()) {
                        stopped = true;
                    }
                    curTime.setAsDouble(t, i, 0L);
                    curDiff.setAsDouble(diff, i, 0L);
                    curMem.setAsLong(mem, i, 0L);
                    System.out.print(".");
                    System.out.flush();
                }
                double meanTime = curTime.getMeanValue();
                double meanDiff = curDiff.getMeanValue();
                double meanMem = curMem.getMeanValue();
                double stdTime = curTime.getStdValue();
                double percentStd = stdTime / meanTime * 100.0;
                System.out.print(" " + MathUtil.round(meanTime, 3) + "+-" + MathUtil.round(stdTime, 3) + "ms (+-" + MathUtil.round(percentStd, 1) + "%)");
                if (!MathUtil.isNaNOrInfinite(meanDiff)) {
                    System.out.print(" diff:" + meanDiff + " ");
                }
                System.out.print(" mem:" + (int)meanMem + " Bytes ");
                if (percentStd > this.config.getMaxStd()) {
                    System.out.print(" standard deviation too large, result discarded");
                    if (tmpTrialCount < this.config.getMaxTrialCount()) {
                        ++tmpTrialCount;
                    }
                }
                if (percentStd < bestStd) {
                    bestStd = percentStd;
                    for (int i2 = 0; i2 < this.config.getRuns(); ++i2) {
                        bestTime.setDouble(curTime.getDouble(i2, 0), i2, 0);
                        bestDiff.setDouble(curDiff.getDouble(i2, 0), i2, 0);
                        bestMem.setDouble(curMem.getDouble(i2, 0), i2, 0);
                    }
                }
                System.out.println();
            }
            for (int i = 0; !stopped && i < this.config.getRuns(); ++i) {
                resultTime.setAsDouble(bestTime.getDouble(i, 0), i, s);
                resultDiff.setAsDouble(bestDiff.getDouble(i, 0), i, s);
                resultMem.setAsDouble(bestMem.getDouble(i, 0), i, s);
            }
        }
        Matrix temp = Matrix.Factory.vertCat(resultTime.getMetaDataDimensionMatrix(0), resultTime);
        Matrix diff = Matrix.Factory.vertCat(resultDiff.getMetaDataDimensionMatrix(0), resultDiff);
        Matrix mem = Matrix.Factory.vertCat(resultMem.getMetaDataDimensionMatrix(0), resultMem);
        try {
            temp.exportTo().file(timeFile).asDenseCSV();
            mem.exportTo().file(memFile).asDenseCSV();
            if (!diff.containsMissingValues()) {
                diff.exportTo().file(diffFile).asDenseCSV();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract BenchmarkResult task(Class<? extends Matrix> var1, long var2, int var4, long[] var5);

    public abstract String getTaskName();

    public String getMatrixLabel() {
        return this.matrixClass.getSimpleName();
    }
}

