/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.openide.util.LookupListener;
import org.openide.util.MetaInfServicesLookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public abstract class Lookup {
    public static final Lookup EMPTY = new Empty();
    private static Lookup defaultLookup;
    static /* synthetic */ Class class$org$openide$util$Lookup;
    static /* synthetic */ Class class$org$openide$util$Lookup$Provider;
    static /* synthetic */ Class class$java$lang$Object;

    public static synchronized Lookup getDefault() {
        if (defaultLookup != null) {
            return defaultLookup;
        }
        String className = System.getProperty("org.openide.util.Lookup");
        if ("-".equals(className)) {
            return EMPTY;
        }
        ClassLoader l = Thread.currentThread().getContextClassLoader();
        try {
            if (className != null) {
                defaultLookup = (Lookup)Class.forName(className, true, l).newInstance();
                return defaultLookup;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MetaInfServicesLookup misl = new MetaInfServicesLookup(l);
        defaultLookup = (Lookup)((Lookup)misl).lookup(class$org$openide$util$Lookup == null ? (class$org$openide$util$Lookup = Lookup.class$("org.openide.util.Lookup")) : class$org$openide$util$Lookup);
        if (defaultLookup != null) {
            return defaultLookup;
        }
        Provider prov = (Provider)((Lookup)misl).lookup(class$org$openide$util$Lookup$Provider == null ? (class$org$openide$util$Lookup$Provider = Lookup.class$("org.openide.util.Lookup$Provider")) : class$org$openide$util$Lookup$Provider);
        if (prov != null) {
            defaultLookup = Lookups.proxy(prov);
            return defaultLookup;
        }
        Lookup clLookup = Lookups.singleton(l);
        defaultLookup = new ProxyLookup(new Lookup[]{misl, clLookup});
        return defaultLookup;
    }

    public abstract Object lookup(Class var1);

    public abstract Result lookup(Template var1);

    public Item lookupItem(Template template) {
        Result res = this.lookup(template);
        Iterator it = res.allItems().iterator();
        return it.hasNext() ? (Item)it.next() : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Empty
    extends Lookup {
        private static final Result NO_RESULT = new Result(){

            public void addLookupListener(LookupListener l) {
            }

            public void removeLookupListener(LookupListener l) {
            }

            public Collection allInstances() {
                return Collections.EMPTY_LIST;
            }
        };

        Empty() {
        }

        public Object lookup(Class clazz) {
            return null;
        }

        public Result lookup(Template template) {
            return NO_RESULT;
        }
    }

    public static interface Provider {
        public Lookup getLookup();
    }

    public static abstract class Item {
        public abstract Object getInstance();

        public abstract Class getType();

        public abstract String getId();

        public abstract String getDisplayName();

        public String toString() {
            return this.getId();
        }
    }

    public static abstract class Result {
        public abstract void addLookupListener(LookupListener var1);

        public abstract void removeLookupListener(LookupListener var1);

        public abstract Collection allInstances();

        public Set allClasses() {
            return Collections.EMPTY_SET;
        }

        public Collection allItems() {
            return Collections.EMPTY_SET;
        }
    }

    public static final class Template {
        private int hashCode;
        private Class type;
        private String id;
        private Object instance;

        public Template() {
            this(null);
        }

        public Template(Class type) {
            this(type, null, null);
        }

        public Template(Class type, String id, Object instance) {
            Class clazz = type == null ? (class$java$lang$Object == null ? (class$java$lang$Object = Lookup.class$("java.lang.Object")) : class$java$lang$Object) : type;
            this.type = clazz;
            this.id = id;
            this.instance = instance;
        }

        public Class getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public Object getInstance() {
            return this.instance;
        }

        public int hashCode() {
            if (this.hashCode != 0) {
                return this.hashCode;
            }
            this.hashCode = (this.type == null ? 1 : this.type.hashCode()) + (this.id == null ? 2 : this.id.hashCode()) + (this.instance == null ? 3 : 0);
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Template)) {
                return false;
            }
            Template t = (Template)obj;
            if (this.hashCode() != t.hashCode()) {
                return false;
            }
            if (this.type != t.type) {
                return false;
            }
            if (this.id == null ? t.id != null : !this.id.equals(t.id)) {
                return false;
            }
            if (this.instance == null) {
                return t.instance == null;
            }
            return this.instance.equals(t.instance);
        }

        public String toString() {
            return "Lookup.Template[type=" + this.type + ",id=" + this.id + ",instance=" + this.instance + "]";
        }
    }
}

