/*
 * Decompiled with CFR 0.152.
 */
package jminhep.clcontrol;

import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import jminhep.clcontrol.TableOptions;
import jminhep.gui.SetEnv;

public class TableSettings
extends JPanel {
    public static final long serialVersionUID = 4121L;
    private boolean DEBUG = false;
    protected String[] columnToolTips = new String[]{"test1", null};
    private String[] tip1 = new String[]{"Number of clusters", "Fuzziness (only for c-means)", "Max number of iterations", "Precision for clustering", "Only for c-means"};
    private String[] tip2 = new String[]{"from 2 to inf", "from 1 to 2", ">100", "<0.1", "from 0.5 to 0.99"};
    public JTable table = new JTable(new MyTableModel()){
        private static final long serialVersionUID = 1L;

        @Override
        public String getToolTipText(MouseEvent e) {
            String tip = null;
            Point p = e.getPoint();
            int rowIndex = this.rowAtPoint(p);
            int colIndex = this.columnAtPoint(p);
            int realColumnIndex = this.convertColumnIndexToModel(colIndex);
            if (realColumnIndex == 0) {
                tip = "Set: " + TableSettings.this.tip1[rowIndex];
            } else if (realColumnIndex == 1) {
                tip = "Recomended: " + TableSettings.this.tip2[rowIndex];
            }
            return tip;
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            return new JTableHeader(this.columnModel){
                private static final long serialVersionUID = 1L;

                @Override
                public String getToolTipText(MouseEvent e) {
                    Point p = e.getPoint();
                    int index = this.columnModel.getColumnIndexAtX(p.x);
                    int realIndex = this.columnModel.getColumn(index).getModelIndex();
                    return TableSettings.this.columnToolTips[realIndex];
                }
            };
        }
    };

    public TableSettings() {
        super(new GridLayout(1, 0));
        int hh = (int)(0.15 * (double)SetEnv.SizeY / 5.69);
        this.table.setRowHeight(hh);
        TableColumn column = null;
        column = this.table.getColumnModel().getColumn(0);
        column.setPreferredWidth(110);
        column.setMinWidth(50);
        column.setMaxWidth(320);
        column = this.table.getColumnModel().getColumn(1);
        column.setPreferredWidth(90);
        column.setMinWidth(50);
        column.setMaxWidth(300);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add(scrollPane);
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("TableToolTipsDemo");
        frame.setDefaultCloseOperation(3);
        TableOptions newContentPane = new TableOptions();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableSettings.createAndShowGUI();
            }
        });
    }

    class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] columnNames = new String[]{"Name", "Settings"};
        private Object[][] data = new Object[][]{{"No clusters", new Integer(3)}, {"Fuzziness", new Double(1.7)}, {"Max interations", new Integer(200)}, {"Precision", new Double(0.01)}, {"Prob. Clusters", new Double(0.68)}};

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col >= 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (TableSettings.this.DEBUG) {
                System.out.println("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
            }
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
            if (TableSettings.this.DEBUG) {
                System.out.println("New value of data:");
                this.printDebugData();
            }
        }

        private void printDebugData() {
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            for (int i = 0; i < numRows; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < numCols; ++j) {
                    System.out.print("  " + this.data[i][j]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }
}

