/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised.constraints;

import cc.mallet.fst.semi_supervised.StateLabelMap;
import cc.mallet.fst.semi_supervised.constraints.GEConstraint;
import cc.mallet.fst.semi_supervised.constraints.OneLabelGEConstraints;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;

public class OneLabelL2GEConstraints
extends OneLabelGEConstraints {
    public OneLabelL2GEConstraints() {
    }

    private OneLabelL2GEConstraints(IntObjectHashMap<OneLabelGEConstraints.OneLabelGEConstraint> constraints, StateLabelMap map) {
        super(constraints, map);
    }

    @Override
    public GEConstraint copy() {
        return new OneLabelL2GEConstraints((IntObjectHashMap<OneLabelGEConstraints.OneLabelGEConstraint>)this.constraints, this.map);
    }

    @Override
    public void addConstraint(int fi, double[] target, double weight) {
        this.constraints.put(fi, (Object)new OneLabelGEL2Constraint(target, weight));
    }

    @Override
    public double getValue() {
        double value = 0.0;
        for (ObjectCursor fi : this.constraints.values()) {
            OneLabelGEConstraints.OneLabelGEConstraint constraint = (OneLabelGEConstraints.OneLabelGEConstraint)fi.value;
            if (!(constraint.count > 0.0)) continue;
            double featureValue = 0.0;
            for (int labelIndex = 0; labelIndex < this.map.getNumLabels(); ++labelIndex) {
                double ex = constraint.expectation[labelIndex] / constraint.count;
                featureValue -= Math.pow(constraint.target[labelIndex] - ex, 2.0);
            }
            assert (!Double.isNaN(featureValue) && !Double.isInfinite(featureValue));
            value += featureValue * constraint.weight;
        }
        return value;
    }

    protected class OneLabelGEL2Constraint
    extends OneLabelGEConstraints.OneLabelGEConstraint {
        public OneLabelGEL2Constraint(double[] target, double weight) {
            super(target, weight);
        }

        @Override
        public double getValue(int li) {
            assert (this.count != 0.0);
            return 2.0 * this.weight * (this.target[li] / this.count - this.expectation[li] / (this.count * this.count));
        }
    }
}

